/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MnsDrawDto;
import com.baijia.tianxiao.sal.marketing.commons.service.mq.MqService;
import com.baijia.tianxiao.sal.marketing.commons.utils.MnsUtils;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.dto.WinnerDto;
import com.baijia.tianxiao.sal.marketing.draw.service.WinnerService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WinnerServiceImpl
implements WinnerService {
    private static final Logger log = LoggerFactory.getLogger(WinnerServiceImpl.class);
    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private MqService mqService;
    @Autowired
    private DrawActivityDao drawActivityDao;

    @Override
    public List<Winner> getWinnerList(long activityId, PageInfo pageInfo) {
        List winners = this.winnerDao.selectWinnerListByPage(activityId, pageInfo);
        if (GenericsUtils.isNullOrEmpty((Object)winners)) {
            return Collections.emptyList();
        }
        for (Winner winner : winners) {
            String username = winner.getName();
            String mobile = winner.getMobile();
            String userInfo = winner.getUserInfo();
            TwoTuple<String, String> retInfo = this.retrievalUserInfo(username, mobile, userInfo);
            winner.setName((String)retInfo.first);
            winner.setMobile((String)retInfo.second);
        }
        return winners;
    }

    private TwoTuple<String, String> retrievalUserInfo(String username, String mobile, String userInfo) {
        if (GenericsUtils.isNullOrEmpty((Object)username) || GenericsUtils.isNullOrEmpty((Object)mobile)) {
            if (GenericsUtils.isNullOrEmpty((Object)userInfo)) {
                return TupleUtil.tuple(username, mobile);
            }
            JSONObject fromObject = JSONObject.fromObject((Object)userInfo);
            String name = fromObject.getString("name");
            String userMobile = fromObject.getString("mobile");
            username = GenericsUtils.isNullOrEmpty((Object)username) ? name : username;
            mobile = GenericsUtils.isNullOrEmpty((Object)mobile) ? userMobile : mobile;
        }
        return TupleUtil.tuple(username, mobile);
    }

    @Override
    public List<WinnerDto> getWinnerDtoList(long activityId, PageInfo pageInfo) {
        List winners = this.winnerDao.selectWinnerListByPage(activityId, pageInfo);
        ArrayList<WinnerDto> dtos = new ArrayList<WinnerDto>(winners.size());
        for (Winner winner : winners) {
            dtos.add(WinnerDto.getDto(winner));
        }
        return dtos;
    }

    @Override
    public void addCheckInInfo(Winner winner) {
        Winner oldWinner = this.winnerDao.selectWinnerById(winner.getDrawId());
        if (oldWinner == null) {
            log.warn("[CheckInInfo] Winner is not existed.{}", (Object)winner);
            return;
        }
        if (StringUtils.isNotBlank((String)oldWinner.getMobile())) {
            log.warn("[CheckInInfo] The prize was checked.{}", (Object)winner);
            return;
        }
        DrawInfo info = this.drawActivityDao.getDrawInfoDetail(oldWinner.getActivityId(), null);
        oldWinner.setName(winner.getName());
        oldWinner.setMobile(winner.getMobile());
        this.mqService.pushMns(MnsDrawDto.getInstance(info, oldWinner), MnsUtils.getPrefix());
        this.winnerDao.updateCheckInInfo(winner);
    }
}

