/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.service.impl;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.marketing.article.service.ImageFileService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.vote.utils.FileUploadUtils;
import com.baijia.tianxiao.sal.marketing.vote.utils.FileUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImageFileServiceImpl
implements ImageFileService {
    private static final Logger log = LoggerFactory.getLogger(ImageFileServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(String src) {
        if (GenericsUtils.isNullOrEmpty((Object)src)) {
            return null;
        }
        FileOutputStream output = null;
        File storeFile = null;
        try {
            byte[] download = HttpClientUtils.download((String)src);
            storeFile = FileUtils.getTemplateFile(System.currentTimeMillis() + "_" + Math.random() * 1000000.0 + ".png");
            output = new FileOutputStream(storeFile);
            output.write(download);
        }
        catch (Exception e) {
            log.info("[Download] Exception. and not will change the image url", (Throwable)e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                log.error("[Download] IOException.", (Throwable)e);
            }
        }
        return storeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> downloadAndUploadManys(List<String> srcs) {
        TreeMap<String, String> srcAndUrl = new TreeMap<String, String>();
        TreeMap<String, File> storeFiles = new TreeMap<String, File>();
        try {
            int size = srcs.size();
            int pageSize = 6;
            int totalPage = size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
            for (int pageNum = 1; pageNum <= totalPage; ++pageNum) {
                int firstIndex = (pageNum - 1) * pageSize;
                int lastIndex = firstIndex + pageSize;
                lastIndex = lastIndex > size ? size : lastIndex;
                List<String> subList = srcs.subList(firstIndex, lastIndex);
                log.info(" total image size is : {} ", (Object)subList.size());
                for (String src : subList) {
                    File downloadAndUpload = this.download(src);
                    if (downloadAndUpload == null) continue;
                    log.info("{src is : {} }", (Object)src);
                    log.info("local file is : {} ", (Object)downloadAndUpload.getAbsolutePath());
                    storeFiles.put(downloadAndUpload.getName(), downloadAndUpload);
                }
                try {
                    UploadResult uploadResult = FileUploadUtils.uploadFiles(null, storeFiles, false);
                    int resultCount = uploadResult.getFiles().size();
                    log.info("Result Count is : {} ", (Object)resultCount);
                    log.info("upload result is : {} ", (Object)ToStringBuilder.reflectionToString((Object)uploadResult));
                    int index = 0;
                    for (UploadResult.UploadFile upload : uploadResult.getFiles()) {
                        srcAndUrl.put(subList.get(index++), Config.IMAGE_SERVER_HOST + upload.getUrl());
                    }
                    continue;
                }
                finally {
                    Collection<File> values = storeFiles.values();
                    for (File file : values) {
                        try {
                            file.delete();
                        }
                        catch (Exception e) {
                            log.error("delete file fail !");
                        }
                    }
                    storeFiles.clear();
                }
            }
            return srcAndUrl;
        }
        catch (Exception e) {
            log.error("[Download] Batch download Exception", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public String downloadAndUploadOne(String src) {
        String newSrc = this.downloadAndUploadManys(Arrays.asList(src)).get(src);
        if (GenericsUtils.isNullOrEmpty((Object)newSrc)) {
            newSrc = src;
        }
        return newSrc;
    }
}

