/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.vote.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteDataStatisticService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoteDataStatisticServiceImpl
implements VoteDataStatisticService {
    private static final Logger log = LoggerFactory.getLogger(VoteDataStatisticServiceImpl.class);
    @Autowired
    VoteInfoDao VoteInfoDao;
    @Autowired
    ActivityUserDao activityUserDao;
    @Autowired
    ActivityAccessLogDao activityAccessLogDao;

    @Override
    public Map<Long, VoteStatistics> getVoteData(Date startDate, Date endDate, String curDate, List<Long> TianxiaoOrgIds) {
        HashMap<Long, VoteStatistics> voteDatas = new HashMap<Long, VoteStatistics>();
        List orgIds = this.VoteInfoDao.getExistOrgIds(TianxiaoOrgIds);
        if (orgIds == null || orgIds.size() == 0) {
            return voteDatas;
        }
        Map allOrgIdActivityIdMap = this.VoteInfoDao.getVoteActivityIdsByOrgIds(orgIds, null, null);
        Map newOrgIdActivityIdMap = this.VoteInfoDao.getVoteActivityIdsByOrgIds(orgIds, startDate, endDate);
        for (Long orgId : orgIds) {
            VoteStatistics voteStatisticData = new VoteStatistics();
            Integer voteActivityTotal = GenericsUtils.isNullOrEmpty(newOrgIdActivityIdMap.get(orgId)) ? Integer.valueOf(0) : Integer.valueOf(((List)newOrgIdActivityIdMap.get(orgId)).size());
            List activityIds = (List)allOrgIdActivityIdMap.get(orgId);
            Integer browseCount = 0;
            browseCount = curDate != null ? this.activityAccessLogDao.getActivityAccessLogTotalByDay(activityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()), curDate) : this.activityAccessLogDao.getActivityAccessLogTotal(activityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()));
            log.info("orgid = " + orgId + "    \u6295\u7968\u8bbf\u95ee\u4eba\u6570===========" + browseCount);
            Integer voteCount = this.activityUserDao.getUserTotal(activityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()), startDate, endDate);
            voteStatisticData.setVoteActivityTotal(voteActivityTotal == null ? 0 : voteActivityTotal);
            voteStatisticData.setBrowseCount(browseCount == null ? 0 : browseCount);
            voteStatisticData.setVoteCount(voteCount == null ? 0 : voteCount);
            voteDatas.put(orgId, voteStatisticData);
        }
        return voteDatas;
    }
}

