/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MnsDrawDto;
import com.baijia.tianxiao.sal.marketing.commons.service.mq.MqService;
import com.baijia.tianxiao.sal.marketing.draw.dto.WinnerDto;
import com.baijia.tianxiao.sal.marketing.draw.service.WinnerService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WinnerServiceImpl
implements WinnerService {
    private static final Logger log = LoggerFactory.getLogger(WinnerServiceImpl.class);
    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private MqService mqService;
    @Autowired
    private DrawActivityDao drawActivityDao;

    @Override
    public List<Winner> getWinnerList(long activityId, PageInfo pageInfo) {
        List winners = this.winnerDao.selectWinnerListByPage(activityId, pageInfo);
        return winners;
    }

    @Override
    public List<WinnerDto> getWinnerDtoList(long activityId, PageInfo pageInfo) {
        List winners = this.winnerDao.selectWinnerListByPage(activityId, pageInfo);
        ArrayList<WinnerDto> dtos = new ArrayList<WinnerDto>(winners.size());
        for (Winner winner : winners) {
            dtos.add(WinnerDto.getDto(winner));
        }
        return dtos;
    }

    @Override
    public void addCheckInInfo(Winner winner) {
        Winner oldWinner = this.winnerDao.selectWinnerById(winner.getDrawId());
        if (oldWinner == null) {
            log.error("[CheckInInfo] Winner is not existed" + ToStringBuilder.reflectionToString((Object)winner));
            return;
        }
        if (StringUtils.isNotBlank((String)oldWinner.getMobile())) {
            log.error("[CheckInInfo] The prize was checked." + ToStringBuilder.reflectionToString((Object)winner));
            return;
        }
        DrawInfo info = this.drawActivityDao.getDrawInfoDetail(oldWinner.getActivityId(), null);
        oldWinner.setName(winner.getName());
        oldWinner.setMobile(winner.getMobile());
        this.mqService.pushMns(MnsDrawDto.getInstance(info, oldWinner), "7$");
        this.winnerDao.updateCheckInInfo(winner);
    }
}

