/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawStatisticData;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawDataExportService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrawDataExportServiceImpl
implements DrawDataExportService {
    @Autowired
    DrawActivityDao drawActivityDao;
    @Autowired
    ActivityUserDao activityUserDao;
    @Autowired
    WinnerDao winnerDao;

    @Override
    public Map<Long, DrawStatisticData> getDrawData(Date startDate, Date endDate, String curDate, List<Long> TianxiaoOrgIds) {
        HashMap<Long, DrawStatisticData> activityDatas = new HashMap<Long, DrawStatisticData>();
        List orgIds = this.drawActivityDao.getExistOrgIds(TianxiaoOrgIds);
        if (orgIds == null || orgIds.size() == 0) {
            return activityDatas;
        }
        Map activityIdsOfOrgId = this.drawActivityDao.getDrawActivitysByIds(orgIds, null, null);
        Map activityIdsOfOrgIdByDay = this.drawActivityDao.getDrawActivitysByIds(orgIds, startDate, endDate);
        for (Long orgId : orgIds) {
            DrawStatisticData drawStatisticData = new DrawStatisticData();
            Integer drawActivityTotal = activityIdsOfOrgIdByDay.get(orgId) != null ? Integer.valueOf(((List)activityIdsOfOrgIdByDay.get(orgId)).size()) : Integer.valueOf(0);
            List activityIds = (List)activityIdsOfOrgId.get(orgId);
            Integer drawUserTotal = this.activityUserDao.getUserTotal(activityIds, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), startDate, endDate);
            Integer drawWinnerTotal = this.winnerDao.getWinnerTotal(activityIds, startDate, endDate);
            drawStatisticData.setDrawActivityTotal(drawActivityTotal == null ? 0 : drawActivityTotal);
            drawStatisticData.setWinnerCount(drawWinnerTotal == null ? 0 : drawWinnerTotal);
            drawStatisticData.setUserCount(drawUserTotal == null ? 0 : drawUserTotal);
            activityDatas.put(orgId, drawStatisticData);
        }
        return activityDatas;
    }
}

