/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.beans.BeanUtils;

public class ReferralBaseInfo {
    private Long activityId;
    @JsonIgnore
    private Long orgId;
    private String title;
    private String subTitle;
    private Integer countLimit;
    private Long startTime;
    private Long endTime;
    private Long updateTime;
    private Long createTime;
    private Integer status;
    private String topPicUrl;
    private String contact;
    private Long templateId;
    private Integer browseCount;
    private Integer brokerNum;
    private Integer customerNum;
    private Integer toPayAmount;
    public static final String REGEX = "\\n";

    public ReferralInfo buildPo() {
        ReferralInfo po = new ReferralInfo();
        BeanUtils.copyProperties((Object)this, (Object)po, (String[])new String[]{"startTime", "endTime"});
        String contact = po.getContact();
        if (this.getStartTime() != null && this.getStartTime() > 0L) {
            po.setStartTime(new Timestamp(this.getStartTime()));
        }
        if (this.getEndTime() != null && this.getEndTime() > 0L) {
            po.setEndTime(new Timestamp(this.getEndTime()));
        }
        return po;
    }

    private static String solveContact(String contact) {
        String replace = contact.replaceAll(REGEX, "</br>");
        return replace;
    }

    public static void main(String[] args) {
        String contact = "www.tast.\nfdhfdsafd";
        System.out.println(ReferralBaseInfo.solveContact(contact));
    }

    public static ReferralBaseInfo buildDto(ReferralInfo info) {
        ReferralBaseInfo rbi = new ReferralBaseInfo();
        BeanUtils.copyProperties((Object)info, (Object)rbi);
        rbi.setUpdateTime(info.getUpdateTime().getTime());
        rbi.setCreateTime(info.getCreateTime().getTime());
        rbi.setStartTime(info.getStartTime().getTime());
        rbi.setEndTime(info.getEndTime().getTime());
        ReferralBaseInfo.checkStatus(info, rbi);
        return rbi;
    }

    public static void checkStatus(ReferralInfo info, ReferralBaseInfo rbi) {
        if (info.getStatus().intValue() == ActivityStatus.CLOSED.getCode()) {
            rbi.setStatus(info.getStatus());
        } else if (info.getStartTime().after(new Date())) {
            rbi.setStatus(ActivityStatus.UN_START.getCode());
        } else if (info.getEndTime().before(new Date())) {
            rbi.setStatus(ActivityStatus.END.getCode());
        } else {
            rbi.setStatus(ActivityStatus.RUNNING.getCode());
        }
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public Integer getCountLimit() {
        return this.countLimit;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getTopPicUrl() {
        return this.topPicUrl;
    }

    public String getContact() {
        return this.contact;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public Integer getBrowseCount() {
        return this.browseCount;
    }

    public Integer getBrokerNum() {
        return this.brokerNum;
    }

    public Integer getCustomerNum() {
        return this.customerNum;
    }

    public Integer getToPayAmount() {
        return this.toPayAmount;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setTopPicUrl(String topPicUrl) {
        this.topPicUrl = topPicUrl;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void setBrowseCount(Integer browseCount) {
        this.browseCount = browseCount;
    }

    public void setBrokerNum(Integer brokerNum) {
        this.brokerNum = brokerNum;
    }

    public void setCustomerNum(Integer customerNum) {
        this.customerNum = customerNum;
    }

    public void setToPayAmount(Integer toPayAmount) {
        this.toPayAmount = toPayAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferralBaseInfo)) {
            return false;
        }
        ReferralBaseInfo other = (ReferralBaseInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$activityId = this.getActivityId();
        Long other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !((Object)this$activityId).equals(other$activityId)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        Integer this$countLimit = this.getCountLimit();
        Integer other$countLimit = other.getCountLimit();
        if (this$countLimit == null ? other$countLimit != null : !((Object)this$countLimit).equals(other$countLimit)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$topPicUrl = this.getTopPicUrl();
        String other$topPicUrl = other.getTopPicUrl();
        if (this$topPicUrl == null ? other$topPicUrl != null : !this$topPicUrl.equals(other$topPicUrl)) {
            return false;
        }
        String this$contact = this.getContact();
        String other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
            return false;
        }
        Long this$templateId = this.getTemplateId();
        Long other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        Integer this$browseCount = this.getBrowseCount();
        Integer other$browseCount = other.getBrowseCount();
        if (this$browseCount == null ? other$browseCount != null : !((Object)this$browseCount).equals(other$browseCount)) {
            return false;
        }
        Integer this$brokerNum = this.getBrokerNum();
        Integer other$brokerNum = other.getBrokerNum();
        if (this$brokerNum == null ? other$brokerNum != null : !((Object)this$brokerNum).equals(other$brokerNum)) {
            return false;
        }
        Integer this$customerNum = this.getCustomerNum();
        Integer other$customerNum = other.getCustomerNum();
        if (this$customerNum == null ? other$customerNum != null : !((Object)this$customerNum).equals(other$customerNum)) {
            return false;
        }
        Integer this$toPayAmount = this.getToPayAmount();
        Integer other$toPayAmount = other.getToPayAmount();
        return !(this$toPayAmount == null ? other$toPayAmount != null : !((Object)this$toPayAmount).equals(other$toPayAmount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferralBaseInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : ((Object)$activityId).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        Integer $countLimit = this.getCountLimit();
        result = result * 59 + ($countLimit == null ? 43 : ((Object)$countLimit).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $topPicUrl = this.getTopPicUrl();
        result = result * 59 + ($topPicUrl == null ? 43 : $topPicUrl.hashCode());
        String $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
        Long $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        Integer $browseCount = this.getBrowseCount();
        result = result * 59 + ($browseCount == null ? 43 : ((Object)$browseCount).hashCode());
        Integer $brokerNum = this.getBrokerNum();
        result = result * 59 + ($brokerNum == null ? 43 : ((Object)$brokerNum).hashCode());
        Integer $customerNum = this.getCustomerNum();
        result = result * 59 + ($customerNum == null ? 43 : ((Object)$customerNum).hashCode());
        Integer $toPayAmount = this.getToPayAmount();
        result = result * 59 + ($toPayAmount == null ? 43 : ((Object)$toPayAmount).hashCode());
        return result;
    }

    public String toString() {
        return "ReferralBaseInfo(activityId=" + this.getActivityId() + ", orgId=" + this.getOrgId() + ", title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", countLimit=" + this.getCountLimit() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", updateTime=" + this.getUpdateTime() + ", createTime=" + this.getCreateTime() + ", status=" + this.getStatus() + ", topPicUrl=" + this.getTopPicUrl() + ", contact=" + this.getContact() + ", templateId=" + this.getTemplateId() + ", browseCount=" + this.getBrowseCount() + ", brokerNum=" + this.getBrokerNum() + ", customerNum=" + this.getCustomerNum() + ", toPayAmount=" + this.getToPayAmount() + ")";
    }
}

