/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.MarketingEntryDao;
import com.baijia.tianxiao.dal.activity.po.MarketingEntry;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MarketingEntryDto;
import com.baijia.tianxiao.sal.marketing.commons.service.MarketingEntryService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketingEntryServiceImpl
implements MarketingEntryService {
    private static final Logger log = LoggerFactory.getLogger(MarketingEntryServiceImpl.class);
    @Autowired
    private MarketingEntryDao entryDao;
    @Autowired
    private TxAccountPermissionService permissionService;

    @Override
    public List<MarketingEntryDto> getAllMarketingEntry(boolean hasSmartPromote, String version, Integer orgId, Integer cascadeId) {
        ArrayList<MarketingEntryDto> dtoList = new ArrayList<MarketingEntryDto>();
        List entries = this.entryDao.selectAllMarketingEntries();
        LinkedHashMap<Integer, MarketingEntryDto> entryMap = new LinkedHashMap<Integer, MarketingEntryDto>();
        TxAccountPermissionsDto permissions = this.permissionService.universalGetPermissions(orgId.intValue(), cascadeId);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        if (permissions != null && permissions.getAPPps() != null && permissions.getAPPps().size() > 0) {
            for (TxAccountPermissionsDto.AccountPermissionDto permissionDto : permissions.getAPPps()) {
                map.put(permissionDto.getPCode(), permissionDto.getPType());
            }
        }
        log.info("[MarketingEntry] permissions={}", map);
        Collections.sort(entries, new Comparator<MarketingEntry>(){

            @Override
            public int compare(MarketingEntry o1, MarketingEntry o2) {
                if (o1.getGroupId() == o2.getGroupId()) {
                    return o1.getSortNum() - o2.getSortNum();
                }
                return o1.getGroupId() - o2.getGroupId();
            }
        });
        for (MarketingEntry entry : entries) {
            MarketingEntryDto dto;
            if (version.compareTo(entry.getVersion()) < 0 && version.compareTo(Config.LAST_APP_VERSION) < 0 || map.get(entry.getPermissionCode()) != null && (Integer)map.get(entry.getPermissionCode()) == 1) continue;
            if (entry.getEvent().equals("tx_event_smartpromotion")) {
                if (!hasSmartPromote) continue;
                dto = MarketingEntryDto.createFromMarketingEntry(entry);
                entryMap.put(dto.getId(), dto);
                continue;
            }
            dto = MarketingEntryDto.createFromMarketingEntry(entry);
            entryMap.put(dto.getId(), dto);
        }
        Set keySet = entryMap.keySet();
        for (Integer key : keySet) {
            MarketingEntryDto dto = (MarketingEntryDto)((Object)entryMap.get(key));
            if (dto.getParentId() <= 0) {
                dtoList.add(dto);
                continue;
            }
            MarketingEntryDto parentEntry = (MarketingEntryDto)((Object)entryMap.get(dto.getParentId()));
            if (parentEntry == null) continue;
            parentEntry.getSubEntries().add(dto);
        }
        return dtoList;
    }
}

