/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateTypeDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TemplateType;
import com.baijia.tianxiao.sal.marketing.activity.dto.TemplateDto;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.TemplateService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private TemplateTypeDao templateTypeDao;

    @Override
    public List<TemplateDto> getTemplateByTypeId(int typeId, TemplateTypeCategory category, PageInfo page) {
        HashSet<Integer> typeIds = new HashSet<Integer>();
        Map<Integer, TemplateType> typeMap = new HashMap();
        if (typeId < 1) {
            List typeList = this.templateTypeDao.selectTemplateTypeListByCategory(category.getType());
            for (TemplateType type : typeList) {
                typeMap.put(type.getTypeId(), type);
                typeIds.add(type.getTypeId());
            }
        } else {
            typeIds.add(typeId);
            typeMap = this.templateTypeDao.selectTypeByIds(typeIds);
        }
        List templateList = this.templateDao.selectTemplateListByTypeId(typeIds, page);
        ArrayList<TemplateDto> dtoList = new ArrayList<TemplateDto>();
        for (Template template : templateList) {
            TemplateDto dto = TemplateDto.getInstance(template);
            dto.setUrl(Config.DOMAIN + template.getUrl());
            dto.setDesc(template.getActivityDesc());
            dtoList.add(dto);
        }
        this.logger.info("[Debug] typeMap=" + typeMap);
        for (TemplateDto dto : dtoList) {
            dto.setInitial(((TemplateType)typeMap.get(dto.getTypeId())).getFlag());
            dto.setUrl(dto.getUrl() + "#!/");
        }
        return dtoList;
    }

    @PostConstruct
    public void init() {
        List templateList = this.templateDao.selectTemplateList();
        if (templateList != null && templateList.size() > 0) {
            for (Template template : templateList) {
                TemplateConstant.getMap().put(template.getTemplateId(), template);
            }
        }
        this.logger.info("[Init template]=" + TemplateConstant.getMap());
    }
}

