/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;
import com.baijia.tianxiao.sal.marketing.referral.enums.AccountType;
import org.apache.commons.lang.StringUtils;

public class CommissionDto {
    private long activityId;
    private String brokerName;
    private String brokerPhone;
    private String accountType;
    private String accountNum = "0";
    private String amount;
    private Long settleTime;
    private Long lastMarkTime;
    private Integer giftType = 2;

    public static CommissionDto getInstanceFromRecord(ReferralRecord record) {
        CommissionDto dto = new CommissionDto();
        dto.setActivityId(record.getActivityId());
        dto.setBrokerName(record.getBrokerName());
        dto.setBrokerPhone(record.getBrokerPhone());
        if (StringUtils.isNotBlank((String)record.getAccountNum())) {
            dto.setAccountNum(record.getAccountNum());
        }
        dto.setAmount(record.getGiftDesc());
        dto.setLastMarkTime(record.getMarkTime().getTime());
        if (record.getType() == 1) {
            dto.setGiftType(1);
        }
        dto.setAccountType(AccountType.ZHI_FU_BAO.getName());
        if (record.getSettlementStatus() == 1) {
            dto.setSettleTime(record.getUpdateTime().getTime());
        }
        return dto;
    }

    public long getActivityId() {
        return this.activityId;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getBrokerPhone() {
        return this.brokerPhone;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getAccountNum() {
        return this.accountNum;
    }

    public String getAmount() {
        return this.amount;
    }

    public Long getSettleTime() {
        return this.settleTime;
    }

    public Long getLastMarkTime() {
        return this.lastMarkTime;
    }

    public Integer getGiftType() {
        return this.giftType;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public void setBrokerPhone(String brokerPhone) {
        this.brokerPhone = brokerPhone;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setSettleTime(Long settleTime) {
        this.settleTime = settleTime;
    }

    public void setLastMarkTime(Long lastMarkTime) {
        this.lastMarkTime = lastMarkTime;
    }

    public void setGiftType(Integer giftType) {
        this.giftType = giftType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommissionDto)) {
            return false;
        }
        CommissionDto other = (CommissionDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getActivityId() != other.getActivityId()) {
            return false;
        }
        String this$brokerName = this.getBrokerName();
        String other$brokerName = other.getBrokerName();
        if (this$brokerName == null ? other$brokerName != null : !this$brokerName.equals(other$brokerName)) {
            return false;
        }
        String this$brokerPhone = this.getBrokerPhone();
        String other$brokerPhone = other.getBrokerPhone();
        if (this$brokerPhone == null ? other$brokerPhone != null : !this$brokerPhone.equals(other$brokerPhone)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        String this$accountNum = this.getAccountNum();
        String other$accountNum = other.getAccountNum();
        if (this$accountNum == null ? other$accountNum != null : !this$accountNum.equals(other$accountNum)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        Long this$settleTime = this.getSettleTime();
        Long other$settleTime = other.getSettleTime();
        if (this$settleTime == null ? other$settleTime != null : !((Object)this$settleTime).equals(other$settleTime)) {
            return false;
        }
        Long this$lastMarkTime = this.getLastMarkTime();
        Long other$lastMarkTime = other.getLastMarkTime();
        if (this$lastMarkTime == null ? other$lastMarkTime != null : !((Object)this$lastMarkTime).equals(other$lastMarkTime)) {
            return false;
        }
        Integer this$giftType = this.getGiftType();
        Integer other$giftType = other.getGiftType();
        return !(this$giftType == null ? other$giftType != null : !((Object)this$giftType).equals(other$giftType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommissionDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $activityId = this.getActivityId();
        result = result * 59 + (int)($activityId >>> 32 ^ $activityId);
        String $brokerName = this.getBrokerName();
        result = result * 59 + ($brokerName == null ? 43 : $brokerName.hashCode());
        String $brokerPhone = this.getBrokerPhone();
        result = result * 59 + ($brokerPhone == null ? 43 : $brokerPhone.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        String $accountNum = this.getAccountNum();
        result = result * 59 + ($accountNum == null ? 43 : $accountNum.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        Long $settleTime = this.getSettleTime();
        result = result * 59 + ($settleTime == null ? 43 : ((Object)$settleTime).hashCode());
        Long $lastMarkTime = this.getLastMarkTime();
        result = result * 59 + ($lastMarkTime == null ? 43 : ((Object)$lastMarkTime).hashCode());
        Integer $giftType = this.getGiftType();
        result = result * 59 + ($giftType == null ? 43 : ((Object)$giftType).hashCode());
        return result;
    }

    public String toString() {
        return "CommissionDto(activityId=" + this.getActivityId() + ", brokerName=" + this.getBrokerName() + ", brokerPhone=" + this.getBrokerPhone() + ", accountType=" + this.getAccountType() + ", accountNum=" + this.getAccountNum() + ", amount=" + this.getAmount() + ", settleTime=" + this.getSettleTime() + ", lastMarkTime=" + this.getLastMarkTime() + ", giftType=" + this.getGiftType() + ")";
    }
}

