/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.points.dal.sys.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.points.dal.sys.dao.PointsOpTypeDao;
import com.baijia.tianxiao.points.dal.sys.po.PointsOpType;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Repository;

@Repository
public class PointsOpTypeDaoImpl
extends JdbcTemplateDaoSupport<PointsOpType>
implements PointsOpTypeDao {
    @Override
    public List<PointsOpType> getOpTypeByName(String name, Collection<String> excludeNames, long clientId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"\u64cd\u4f5c\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("clientId", (Collection)Sets.newHashSet((Object[])new Long[]{clientId, NumberUtils.LONG_ZERO}));
        builder.eq("name", (Serializable)((Object)name));
        if (CollectionUtils.isNotEmpty(excludeNames)) {
            builder.notin("name", excludeNames);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<PointsOpType> getOpTypeByClientId(long clientId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("clientId", (Collection)Sets.newHashSet((Object[])new Long[]{clientId, NumberUtils.LONG_ZERO}));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public Map<Long, PointsOpType> getPointsOpTypeMap(Collection<Long> ids, String ... properties) {
        List result = this.getByIds(ids, properties);
        Map<Object, Object> cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            cache = result.stream().collect(Collectors.toMap(PointsOpType::getId, p -> p));
        }
        return cache;
    }
}

