/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.enums.StudentCourseStatus;
import java.math.BigDecimal;

public class OrgStudentLessonCounter {
    private static final String PREFIX = "stu_lesson_";
    private static final String SEPARATOR = "_";
    private String id;
    private long userId;
    private long orgId;
    private long courseId;
    private long totalCount;
    private long finishedCount;
    private long leftCount;
    private long totalArrangeTime;
    private long kexiaoTime;
    private BigDecimal leftCountRatio;
    private int studentLessonStatus;

    public boolean isNormalCourse() {
        return this.studentLessonStatus == StudentCourseStatus.NORMAL.getCode();
    }

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX).append(this.userId).append(SEPARATOR).append(this.courseId);
        return sb.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getCourseId() {
        return this.courseId;
    }

    public void setCourseId(long courseId) {
        this.courseId = courseId;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getFinishedCount() {
        return this.finishedCount;
    }

    public void setFinishedCount(long finishedCount) {
        this.finishedCount = finishedCount;
    }

    public long getLeftCount() {
        return this.totalCount - this.finishedCount;
    }

    public void setLeftCount(long leftCount) {
        this.leftCount = leftCount;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getLeftCountRatio() {
        BigDecimal total = new BigDecimal(this.totalCount);
        BigDecimal left = new BigDecimal(this.getLeftCount());
        if (this.getLeftCount() <= 0L) {
            return BigDecimal.ZERO;
        }
        if (this.totalCount <= 0L) {
            return BigDecimal.ZERO;
        }
        return left.divide(total, 2, 6);
    }

    public long getTotalArrangeTime() {
        return this.totalArrangeTime;
    }

    public long getKexiaoTime() {
        return this.kexiaoTime;
    }

    public int getStudentLessonStatus() {
        return this.studentLessonStatus;
    }

    public void setTotalArrangeTime(long totalArrangeTime) {
        this.totalArrangeTime = totalArrangeTime;
    }

    public void setKexiaoTime(long kexiaoTime) {
        this.kexiaoTime = kexiaoTime;
    }

    public void setLeftCountRatio(BigDecimal leftCountRatio) {
        this.leftCountRatio = leftCountRatio;
    }

    public void setStudentLessonStatus(int studentLessonStatus) {
        this.studentLessonStatus = studentLessonStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgStudentLessonCounter)) {
            return false;
        }
        OrgStudentLessonCounter other = (OrgStudentLessonCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        if (this.getOrgId() != other.getOrgId()) {
            return false;
        }
        if (this.getCourseId() != other.getCourseId()) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getFinishedCount() != other.getFinishedCount()) {
            return false;
        }
        if (this.getLeftCount() != other.getLeftCount()) {
            return false;
        }
        if (this.getTotalArrangeTime() != other.getTotalArrangeTime()) {
            return false;
        }
        if (this.getKexiaoTime() != other.getKexiaoTime()) {
            return false;
        }
        BigDecimal this$leftCountRatio = this.getLeftCountRatio();
        BigDecimal other$leftCountRatio = other.getLeftCountRatio();
        if (this$leftCountRatio == null ? other$leftCountRatio != null : !((Object)this$leftCountRatio).equals(other$leftCountRatio)) {
            return false;
        }
        return this.getStudentLessonStatus() == other.getStudentLessonStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgStudentLessonCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $userId = this.getUserId();
        result = result * 59 + (int)($userId >>> 32 ^ $userId);
        long $orgId = this.getOrgId();
        result = result * 59 + (int)($orgId >>> 32 ^ $orgId);
        long $courseId = this.getCourseId();
        result = result * 59 + (int)($courseId >>> 32 ^ $courseId);
        long $totalCount = this.getTotalCount();
        result = result * 59 + (int)($totalCount >>> 32 ^ $totalCount);
        long $finishedCount = this.getFinishedCount();
        result = result * 59 + (int)($finishedCount >>> 32 ^ $finishedCount);
        long $leftCount = this.getLeftCount();
        result = result * 59 + (int)($leftCount >>> 32 ^ $leftCount);
        long $totalArrangeTime = this.getTotalArrangeTime();
        result = result * 59 + (int)($totalArrangeTime >>> 32 ^ $totalArrangeTime);
        long $kexiaoTime = this.getKexiaoTime();
        result = result * 59 + (int)($kexiaoTime >>> 32 ^ $kexiaoTime);
        BigDecimal $leftCountRatio = this.getLeftCountRatio();
        result = result * 59 + ($leftCountRatio == null ? 43 : ((Object)$leftCountRatio).hashCode());
        result = result * 59 + this.getStudentLessonStatus();
        return result;
    }

    public String toString() {
        return "OrgStudentLessonCounter(id=" + this.getId() + ", userId=" + this.getUserId() + ", orgId=" + this.getOrgId() + ", courseId=" + this.getCourseId() + ", totalCount=" + this.getTotalCount() + ", finishedCount=" + this.getFinishedCount() + ", leftCount=" + this.getLeftCount() + ", totalArrangeTime=" + this.getTotalArrangeTime() + ", kexiaoTime=" + this.getKexiaoTime() + ", leftCountRatio=" + this.getLeftCountRatio() + ", studentLessonStatus=" + this.getStudentLessonStatus() + ")";
    }
}

