package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoInviteeDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoInvitee;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;

import java.util.Map;

import lombok.NonNull;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 06/06/2017 3:18 PM
 */
@Repository
public class TxVZhiBoInviteeDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoInvitee> implements TxVZhiBoInviteeDao {

    public TxVZhiBoInviteeDaoImpl() {
        super(TxVZhiBoInvitee.class);
    }

    @Override
    public TxVZhiBoInvitee getBySceneIdAndOpenId(Long sceneId, String openId) {
        SingleSqlBuilder<TxVZhiBoInvitee> builder = createSqlBuilder();
        builder.eq("sceneId", sceneId);
        builder.eq("openId", openId);
        return uniqueResult(builder);
    }

    @Override
    public TxVZhiBoInvitee getMaxInviteNumInviter(@NonNull Integer lessonId) {
        StringBuilder builder = new StringBuilder();
        builder.append("select count(1) as count,inviter_type,inviter_id,inviter_open_id from tts.tx_vzhibo_invitee ");
        builder.append(
            "where lesson_id=:lessonId group by inviter_type,inviter_id,inviter_open_id order by count desc limit 1");
        Map<String, Object> params = Maps.newHashMap();
        params.put("lessonId", lessonId);
        TxVZhiBoInvitee result = new TxVZhiBoInvitee();
        this.getNamedJdbcTemplate().query(builder.toString(), params, rs -> {
            result.setCount(rs.getInt("count"));
            result.setInviterType(rs.getInt("inviter_type"));
            result.setInviterId(rs.getInt("inviter_id"));
            result.setInviterOpenId(rs.getString("inviter_open_id"));
        });
        return 0 == result.getCount() ? null : result;
    }

}
