/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author caoliang
 * @version 1.0
 * @title TxVZhiBoLessonDao
 * @desc TODO
 * @date 2016年11月28日
 */
public interface TxVZhiBoLessonStudentDao extends CommonDao<TxVZhiBoLessonStudent> {

    List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId);

    TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId);

    List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize);

    List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize);

    /**
     * 根据直播课id查看所有学生openid
     *
     * @param lessonId
     * @return
     */
    Integer queryStudentOpenIdCountByLessonId(Integer lessonId);

    Map<String, Integer> mapOpenIdStatus(Long lessonId, Collection<String> openIdList);

    /**
     * 分校区计算直播课人数
     *
     * @param startTime
     * @param endTime
     * @param TianxiaoOrgIds
     * @return
     */
    Map<Long, Integer> getLessonStudentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);

}
