package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Date;

import lombok.NonNull;

@Repository
public class OrgSignupOnlinePayDaoImpl extends JdbcTemplateDaoSupport<OrgSignupOnlinePay> implements
    OrgSignupOnlinePayDao {
    public OrgSignupOnlinePayDaoImpl() {
        super(OrgSignupOnlinePay.class);
    }

    @Override
    public OrgSignupOnlinePay getBySmsKey(@NonNull String smsKey, String...queryProps) {
        Preconditions.checkArgument(StringUtils.isNotBlank(smsKey), "sms key can not be empty");
        SingleSqlBuilder<OrgSignupOnlinePay> builder = createSqlBuilder(queryProps);
        builder.eq("smsKey", smsKey);
        return uniqueResult(builder);
    }

    @Override
    public int countByMobileAndPurchaseId(@NonNull Long purchaseId, @NonNull String mobile, @NonNull Date startTime) {
        SingleSqlBuilder<OrgSignupOnlinePay> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("purchaseId", purchaseId);
        builder.eq("toMobile", mobile);
        if (startTime != null) {
            builder.gt("createTime", startTime);
        }
        return queryForObject(builder, Integer.class);
    }

    @Override
    public OrgSignupOnlinePay getLastRecordByPurchaseId(@NonNull Long purchaseId, String...queryProps) {
        SingleSqlBuilder<OrgSignupOnlinePay> builder = createSqlBuilder(queryProps);
        builder.eq("purchaseId", purchaseId);
        builder.desc("id");
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }
}
