
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title OrgWxLiveRoom
 * @desc 机构直播课和直播房间的的对应表。直播间相关数据都在这里，修改课节后会同步修改云端并同步数据到这个表
 *
 * @author leiruiqi
 * @date 2016年12月23日
 * @version 1.0
 */
@Entity
@Table(name = "wx_live_room", catalog = "tts")
@Data
public class WxLiveRoom {

    @Id
    @GeneratedValue
    private Long id;
    
    /**
     * 机构id
     */
    @Column
    private Long orgId;
    
    /**
     * 课节id
     */
    @Column 
    private Long lessonId;
    
    /**
     * 课程id
     */
    @Column   
    private Long courseId;
    
    /**
     * 直播间房间号
     */
    @Column
    private Long roomId;
    
    /**
     * 直播间房间标题
     */
    @Column  
    private String title;
    
    /**
     * 可以进入房间的时间
     */
    @Column
    private Date enterTime;
    /**
     * 直播开始时间
     */
    @Column  
    private Date startTime;
    
    /**
     * 直播结束时间
     */
    @Column
    private Date endTime;
    
    /**
     * 直播类型
     */
    @Column 
    private Integer type;
    
    /**
     * 教务登录码
     */
    @Column
    private String adminCode;
    
    /**
     * 老师登录码
     */
    @Column
    private String teacherCode;
    
    /**
     * 自己控制的状态，预留，应该有用
     */
    @Column 
    private Integer status;
    
    /**
     * 删除状态
     */
    @Column
    private Integer delStatus;
    
    /**
     * 创建时间
     */
    @Column 
    private Date createTime;
    
    /**
     * 修改时间
     */
    @Column
    private Date updateTime;
    
    /**
     * 老师teacherId
     */
        
    @Column
    private Long teacherId;
    
    /**
     * 助教teacherId
     */
        
    @Column
    private Long adminId;
    
    @Column
    private Integer playBack;
    
    @Column
    private Date backTime;
    
    /**
     * 视频播放长度
     */
    @Column   
    private Integer backLength;
    
    /**
     * 占用存储空间的大小
     */
    @Column 
    private Long backSize;
    
}

    