package com.baijia.tianxiao.dal.comment.dao.impl;

import com.baijia.tianxiao.dal.comment.dao.TxCustomFastCommentDao;
import com.baijia.tianxiao.dal.comment.po.TxCustomFastComment;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 31/07/2017 9:09 PM
 */
@Component
public class TxCustomFastCommentDaoImpl extends JdbcTemplateDaoSupport<TxCustomFastComment>
    implements TxCustomFastCommentDao {
    public TxCustomFastCommentDaoImpl() {
        super(TxCustomFastComment.class);
    }

    @Override
    public List<TxCustomFastComment> getCommentsByOrgId(Long orgId, Integer disable) {
        SingleSqlBuilder<TxCustomFastComment> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (null != disable) {
            builder.eq("disable", disable);
        }
        builder.setOrders(Lists.newArrayList(Order.asc("disable"), Order.asc("sort")));
        return this.queryList(builder);
    }

    @Override
    public int getMaxSortByOrgId(Long orgId) {
        String sql = "select max(sort) from tts.tx_custom_fast_comment where org_id=:orgId";
        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        Integer result = this.getNamedJdbcTemplate().queryForObject(sql, params, Integer.TYPE);
        return result == null ? 0 : result;
    }

    @Override
    public int countByOrgId(Long orgId) {
        String sql = "select count(1) from tts.tx_custom_fast_comment where org_id=:orgId";
        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        Integer result = this.getNamedJdbcTemplate().queryForObject(sql, params, Integer.TYPE);
        return result == null ? 0 : result;
    }

    @Override
    public TxCustomFastComment getByOrgIdAndComment(Long orgId, String comment) {
        SingleSqlBuilder<TxCustomFastComment> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (null != comment) {
            builder.eq("comment", comment);
        }
        return uniqueResult(builder);
    }
}
