
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.comment.dao.impl;

import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentSmsDao;
import com.baijia.tianxiao.dal.comment.po.OrgLessonCommentSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;

import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

/**
 * @title OrgLessonCommentSmsDaoImpl
 * @desc TODO
 * @author bjhl
 * @date 2016年1月3日
 * @version 1.0
 */
@Repository
public class OrgLessonCommentSmsDaoImpl extends JdbcTemplateDaoSupport<OrgLessonCommentSms>
    implements OrgLessonCommentSmsDao {

    public OrgLessonCommentSmsDaoImpl() {
        super(OrgLessonCommentSms.class);
    }

    @Override
    public Map<Long, Integer> getSendMap(final Long orgId, final Long lessonId, Collection<Long> userIds,
        final Integer userRole) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        return new MapBatchQueryTemplate<Long, Long, Integer>().batchQuery(userIds,
            new BatchQueryCallback<Long, Map<Long, Integer>>() {

                @Override
                public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                    SingleSqlBuilder<OrgLessonCommentSms> builder = createSqlBuilder("userId", "send");
                    builder.eq("orgId", orgId);
                    builder.eq("lessonId", lessonId);
                    builder.in("userId", querySet);
                    builder.eq("userRole", userRole);
                    final Map<Long, Integer> result = Maps.newHashMap();
                    getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(),
                        new RowCallbackHandler() {
                            @Override
                            public void processRow(ResultSet rs) throws SQLException {
                                result.put(rs.getLong("userId"), rs.getInt("send"));
                            }
                        });
                    return result;
                }
            });
    }

    @Override
    public OrgLessonCommentSms getCommentSms(Long orgId, Long lessonId, Long userId, Integer userRole) {
        SingleSqlBuilder<OrgLessonCommentSms> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("lessonId", lessonId);
        builder.eq("userId", userId);
        builder.eq("userRole", userRole);
        return uniqueResult(builder);
    }
}
