package com.baijia.tianxiao.constant;

/**
 * Created by liuxp on 16/11/17.
 */
public enum KexiaoChangeEvent {
    START(1,"开课时间变化"),
    KEXIAO_REUL(2,"课消规则变化"),
    BATCH_SIGN(3,"批量签到"),
    FAST_SIGN(4,"快速签到"),
    ADD_SIGNUP_INFO(5,"补充报名信息"),
    DEL_LESSON(6,"删除课节"),
    DEL_STUDENT_LESSON(7,"删除学生课节"),
    CANCEL_SIGN(8,"取消签到"),
    STUDENT_LESSON_CHANGE(9,"课节时长变更");


    private int type;
    private String desc;

    private KexiaoChangeEvent(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static KexiaoChangeEvent getByType(int type){
        for (KexiaoChangeEvent changeEvent:KexiaoChangeEvent.values()){
            if(changeEvent.getType()==type){
                return changeEvent;
            }
        }
        return null;
    }
}
