
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title OrgWxLiveRoomRecord
 * @desc 机构直播人数纪录表，即并发数据纪录表
 * @author leiruiqi
 * @date 2016年12月23日
 * @version 1.0
 */
@Entity
@Table(name = "wx_live_room_record", catalog = "tts")
@Data
public class WxLiveRoomRecord {

    @Id
    @GeneratedValue
    private Long id;
    
    @Column
    private Long orgId;
    
    /**
     * 房间id
     */
    @Column 
    private Long roomId;
    
    
    /**
     * 查询时间
     */
    @Column 
    private Date queryTime;
    
    /**
     * 创建时间
     */
    @Column
    private Date createTime;
    
    /**
     * 房间人数
     */
    @Column
    private Integer num;
    
    
}

    