
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title WxCloudSource
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月9日
 * @version 1.0
 */



@Entity
@Table(name = "wx_cloud_source", catalog = "tts")
@Data
public class WxCloudSource {

    @Id
    @GeneratedValue
    private Long id;
    
    @Column
    private Long orgId;
    
    /**
     * 资源类型，1、上传视频，2、直播回放
     */
    @Column  
    private Integer bizType;
    
    /**
     * 云端文件id，如果是直播回放，是直播间的id
     */
    @Column  
    private Long cloudId;
    
    /**
     * 云端状态，0、未上传，初始状态；1、上传中；2、上传完毕，3、转码完成（可播放）-1、转码失败
     * 
     * 直播回放生成好后，直接状态为3
     */
    @Column  
    private Integer status;
    
    /**
     * 是否可见，新上传，到上传成功前，资源列表中对用户不可见，1 可见，0 不可见，初始状态为不可见1，
     */
        
    @Column
    private Integer visible;
    
    /**
     * 是否禁用 0，不禁用，1 禁用
     */
        
    @Column
    private Integer isForbidden;
    
    /**
     * 占用存储空间的大小
     */
    @Column 
    private Long size;
    
    /**
     * 用户自定义分类id
     */
    @Column 
    private Long groupId;
    
    
    /**
     * 用户自定义的名字，（或是上传文件的名字）
     */
    @Column 
    private String name;
    
    /**用户自定义的描述
     * 
     */
    @Column  
    private String info;
    @Column
    private String tags;
    @Column
    private Date createTime;
    @Column
    private Date updateTime;
    
    /**
     * 云端状态
     */
    @Column
    private Integer cloudStatus;
    
    /**
     * 视频播放长度
     */
    @Column   
    private Integer length;
    
    /**
     * 视频封面地址
     */
    @Column
    private String prefaceUrl;
    
    /**
     * 视频发布状态？不知道干嘛用，先记者
     */
    @Column
    private Integer publishStatus;
    
    @Column
    private Integer delStatus;
    
    @Column
    private Integer createUserId;
    
    
    private String createUserName;
    
}


    