
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxLessonAccessRecordDao;
import com.baijia.tianxiao.dal.org.po.WxLessonAccessRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @title WxLessonAccessRecordDaoImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2017年1月12日
 * @version 1.0
 */

@Repository
public class WxLessonAccessRecordDaoImpl extends JdbcTemplateDaoSupport<WxLessonAccessRecord>
    implements WxLessonAccessRecordDao {

    @Override
    public List<WxLessonAccessRecord> queryStudentLastAccessLesson(Long orgId, Long studentId, Long courseId) {

        SingleSqlBuilder<WxLessonAccessRecord> sqlBuilder =
            this.createSqlBuilder("id", "orgId", "course_id", "lesson_id", "studentId", "createTime");

        sqlBuilder.max("create_time", "createTime");
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("studentId", studentId);
        if (courseId != null) {
            sqlBuilder.eq("courseId", courseId);
        }

        sqlBuilder.group("lessonId");
        sqlBuilder.asc("id");
        // sqlBuilder.setOrder(Order.desc("id"));
        return this.queryList(sqlBuilder);

    }

    @Override
    public List<WxLessonAccessRecord> queryLessonLastAccess(Long orgId, Long lessonId) {

        SingleSqlBuilder<WxLessonAccessRecord> sqlBuilder =
            this.createSqlBuilder("id", "orgId", "course_id", "lesson_id", "studentId", "createTime");

        sqlBuilder.max("create_time", "createTime");
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("lessonId", lessonId);
        sqlBuilder.group("studentId");
        sqlBuilder.desc("id");
        // sqlBuilder.setOrder(Order.desc("id"));
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<WxLessonAccessRecord> queryStudentLesson(Long orgId, Long studentId, Long lessonId) {

        SingleSqlBuilder<WxLessonAccessRecord> sqlBuilder = this.createSqlBuilder();

        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("lessonId", lessonId);
        sqlBuilder.eq("studentId", studentId);

        sqlBuilder.desc("id");
        // sqlBuilder.setOrder(Order.desc("id"));
        return this.queryList(sqlBuilder);
    }
}
