package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.KexiaoChangeLogDao;
import com.baijia.tianxiao.dal.org.po.KexiaoChangeLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by liuxp on 16/11/17.
 */
@Repository
public class KexiaoChangeLogDaoImpl extends JdbcTemplateDaoSupport<KexiaoChangeLog> implements KexiaoChangeLogDao {
    @Override
    public List<KexiaoChangeLog> selectByTime(Long orgId, Date startTime, Date endTime, String...props) {
        SingleSqlBuilder sqlBuilder = createSqlBuilder(props);
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.between("createTime", startTime, endTime);
        return queryList(sqlBuilder);
    }

    @Override
    public void batchInsertChangeLogs(List<KexiaoChangeLog> changeLogs) {
        String fields = "event_type,org_id,create_time,info";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("insert into yunying.tx_kexiao_change_log(")
                .append(fields)
                .append(") values(:eventType,:orgId,:createTime,:info)");
        SqlParameterSource[] batch = SqlParameterSourceUtils.createBatch(changeLogs.toArray());
        getNamedJdbcTemplate().batchUpdate(sqlBuilder.toString(),batch);
    }
}
