package com.baijia.tianxiao.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by wengshengli on 2017/7/24.
 */
public enum CourseFinishStatus {
    UN_FINISH(0, "未结课"),
    FINISHED(1, "已结课"),;

    public static Map<Integer,CourseFinishStatus> finishStatusMap = Maps.newHashMap();

    static {
        for (CourseFinishStatus finishStatus : CourseFinishStatus.values()) {
            finishStatusMap.put(finishStatus.getCode(), finishStatus);
        }
    }

    private int code;
    private String name;

    private CourseFinishStatus(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getFinishStatusStr(Integer code) {
        if (code == null) {
            return UN_FINISH.getName();
        }
        CourseFinishStatus one = finishStatusMap.get(code.intValue());
        if (one == null) {
            return UN_FINISH.getName();
        }
        return one.getName();
    }
}
