/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @author caoliang
 * @version 1.0
 * @title TxVZhiBoLessonStudentDaoImpl
 * @desc TODO
 * @date 2016年11月28日
 */
@Repository
public class TxVZhiBoLessonStudentDaoImpl extends JdbcTemplateDaoSupport<TxVZhiBoLessonStudent>
        implements TxVZhiBoLessonStudentDao {

    public TxVZhiBoLessonStudentDaoImpl() {
        super(TxVZhiBoLessonStudent.class);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        return queryList(builder);
    }

    @Override
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
        if (null == openId || null == lessonId) {
            return null;
        }
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("openId", openId);
        builder.eq("lessonId", lessonId);
        return uniqueResult(builder);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        if (lastId != null) {
            builder.gt("id", lastId);
        }
        builder.asc("id");
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        return queryList(builder);
    }

    @Override
    public List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize) {
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder();
        builder.eq("lessonId", lessonId);
        builder.desc("id");
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        return queryList(builder);
    }


    private static final String QUERY_STUDENTOPENID_BY_LESSONID =
            "SELECT COUNT(DISTINCT(open_id)) as c FROM tts.tx_vzhibo_lesson_student WHERE lesson_id =:lessonId";

    @Override
    public Integer queryStudentOpenIdCountByLessonId(Integer lessonId) {
        Map<String, Integer> paramMap = Maps.newHashMap();
        paramMap.put("lessonId", lessonId);
        return this.getNamedJdbcTemplate().queryForObject(QUERY_STUDENTOPENID_BY_LESSONID, paramMap, Integer.class);
    }

    @Override
    public Map<String, Integer> mapOpenIdStatus(Long lessonId, Collection<String> openIdList) {
        Map<String, Integer> result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(openIdList)) {
            return result;
        }
        SingleSqlBuilder<TxVZhiBoLessonStudent> builder = createSqlBuilder("openId", "status");
        builder.eq("lessonId", lessonId);
        builder.in("openId", openIdList);
        queryList(builder).stream().forEach(student -> result.put(student.getOpenId(), student.getStatus()));
        return result;
    }

    @Override
    public Map<Long, Integer> getLessonStudentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select r.org_id, count(1) count from tts.tx_vzhibo_lesson_student ls,tts.tx_vzhibo_room r,tts.tx_vzhibo_lesson ll where ls.room_id = r.id and ls.lesson_id = ll.id and ll.status in (0,1)  and r.org_id in (:orgIds) ";

        if (startTime != null) {
            sql += " and ll.start_time>=:startTime and ll.start_time<=:endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql += " group by r.org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Integer count = rs.getInt("count");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }

        });
    }
}
