package com.baijia.tianxiao.dal.signup.dao.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupStorageDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupStorage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Lists;

@Slf4j
@Repository
public class OrgSignupStorageDaoImpl extends JdbcTemplateDaoSupport<OrgSignupStorage> implements OrgSignupStorageDao {

    public OrgSignupStorageDaoImpl() {
        super(OrgSignupStorage.class);
    }

    @Override
    public void addOrEditOrgSignupStorage(Long orgId, Collection<OrgSignupStorage> orgSignupStorages) {
        for (OrgSignupStorage orgSignupStorage : orgSignupStorages) {
            if (orgSignupStorage.getOrgId() == null) {
                orgSignupStorage.setOrgId(orgId);
            }
        }

        log.debug("orgId = {}, orgSignupStorages = {} size = {}", orgId, orgSignupStorages, orgSignupStorages.size());
        for (OrgSignupStorage signup : orgSignupStorages) {
            List<OrgSignupStorage> temp = getOrgSignupStorage(signup);
            if (CollectionUtils.isNotEmpty(temp)) {
                // 跟新remark
                OrgSignupStorage old = temp.get(0);
                old.setRemark(signup.getRemark());
                this.update(old);
            } else {
                this.save(signup);
            }
        }
    }

    public void delOrgSignupStorage(Collection<OrgSignupStorage> orgSignupStorages) throws Exception {
        for (OrgSignupStorage orgSignupStorage : orgSignupStorages) {
            List<OrgSignupStorage> temp = getOrgSignupStorage(orgSignupStorage);
            if (CollectionUtils.isNotEmpty(temp)) {
                if (temp.size() == 1) {
                    OrgSignupStorage old = temp.get(0);
                    this.delById(old.getId());
                } else {
                    log.error("{} : {}", orgSignupStorages, temp);
                }
            } else {
                throw new Exception("删除失败!");
            }
        }
    }

    private List<OrgSignupStorage> getOrgSignupStorage(OrgSignupStorage signup) {
        if (signup.getId() == null) {
            SingleSqlBuilder<OrgSignupStorage> sqlBuilder = createSqlBuilder();
            sqlBuilder.eq("orgId", signup.getOrgId());
            sqlBuilder.eq("signupPurchaseId", signup.getSignupPurchaseId());
            sqlBuilder.eq("storageId", signup.getStorageId());
            return this.queryList(sqlBuilder);
        }
        List<OrgSignupStorage> list = Lists.newArrayList();
        list.add(this.getById(signup.getId()));
        return list;
    }

    @Override
    public List<OrgSignupStorage> getOrgSignupStorageBySignupPurchaseId(Long orgId, Long signupPurchaseId) {
        SingleSqlBuilder<OrgSignupStorage> sqlBuilder = createSqlBuilder();
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("signupPurchaseId", signupPurchaseId);
        List<OrgSignupStorage> list = queryList(sqlBuilder);
        if (CollectionUtils.isNotEmpty(list)) {
            if (list.size() > 1) {
                Iterator<OrgSignupStorage> it = list.iterator();
                while (it.hasNext()) {
                    if (it.next().getStorageId() == 0) {
                        it.remove();
                    }
                }
            }
        }
        log.debug("list = {}", list);
        return list;
    }

}
