/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.constant;

/**
 * @title ContentTypeEnums
 * @desc 文件类型
 * @author he11o
 * @date 2016年6月1日
 * @version 1.0
 */
public enum MessageTypeEnums {
    TEXT(0),

    PIC(1),

    VOICE(2), //

    STUDENTCOUNT(3), // 学生数量变化通知

    MESSAGERECALL(4); // 消息撤回

    private int code;

    MessageTypeEnums(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static final MessageTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (MessageTypeEnums enums : MessageTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }
    
    public static boolean isDbMsgType(Integer code) {
        if (null == code) {
            return false;
        } else {
            return code == TEXT.getCode() || code == PIC.getCode() || code == VOICE.getCode();
        }
    }

}
