package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupSyncInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupSyncInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/9/12
 * Time: 下午8:38
 * To change this template use File | Settings | File Templates.
 */
@Slf4j
@Repository
public class OrgSignupSyncInfoDaoImpl extends JdbcTemplateDaoSupport<OrgSignupSyncInfo> implements OrgSignupSyncInfoDao {

    public OrgSignupSyncInfoDaoImpl() {
        super(OrgSignupSyncInfo.class);
    }

    @Override
    public OrgSignupSyncInfo getOrgSignupSyncInfo(@NonNull Integer syncType) {
        Preconditions.checkArgument(syncType != null && syncType > 0, "can not get sync info by empty sync type");

        SingleSqlBuilder<OrgSignupSyncInfo> builder = createSqlBuilder();
        builder.eq("syncType", syncType);
        return uniqueResult(builder);
    }

    @Override
    public void saveOrUpdateSyncInfo(@NonNull OrgSignupSyncInfo syncInfo) {
        Preconditions.checkState(syncInfo.getSyncType() != null, "sync type is null");
        if (syncInfo.getId() == null) {
            save(syncInfo);
        } else {
            update(syncInfo);
        }
    }
}
