
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxRoomUserCountDao;
import com.baijia.tianxiao.dal.org.po.WxRoomUserCount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @title WxRoomUserCountDaoImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2017年1月18日
 * @version 1.0
 */
@Repository
public class WxRoomUserCountDaoImpl extends JdbcTemplateDaoSupport<WxRoomUserCount> implements WxRoomUserCountDao {

    public List<WxRoomUserCount> queryByOrgIdForUpdate(Long orgId, boolean forUpdate) {

        SingleSqlBuilder<WxRoomUserCount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        return this.queryList(builder, forUpdate);

    }

    public int addOneByOrgIdAndRoomId(Long orgId, Long roomId) {
        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("roomId", roomId);
        String sql = "update tts.wx_room_user_count set count=count+1 where org_id = :orgId and room_id = :roomId ";
        return this.getNamedJdbcTemplate().update(sql, condition);
    }

}
