package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgLessonSignLogDao;
import com.baijia.tianxiao.dal.org.po.OrgLessonSignLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import lombok.NonNull;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author weihongyan
 * @description TODO
 * @date 05/01/2017
 */
@Repository
public class OrgLessonSignLogDaoImpl extends JdbcTemplateDaoSupport<OrgLessonSignLog> implements OrgLessonSignLogDao {

    public OrgLessonSignLogDaoImpl() {
        super(OrgLessonSignLog.class);
    }

    @Override
    public List<OrgLessonSignLog> getSignLogByLessonUserId(@NonNull Long orgId, @NonNull Long lessonId,
        @NonNull Long userId, String... props) {
        SingleSqlBuilder<OrgLessonSignLog> builder = createSqlBuilder(props);
        builder.eq("lessonId", lessonId);
        builder.eq("userId", userId);
        builder.eq("orgId", orgId);
        builder.desc("createTime");
        return queryList(builder);
    }
}
