package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxCategoryDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * Created by wangsixia on 2017/1/13.
 */
@Repository
public class WxCategoryDaoImpl extends JdbcTemplateDaoSupport<WxCategory> implements WxCategoryDao {

    @Override
    public List<WxCategory> getListByParam(Long orgId, Integer type, Collection<Long> ids) {
        SingleSqlBuilder<WxCategory> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("isDel", DeleteStatus.NORMAL.getValue());
        builder.desc("displayOrder");
        if (CollectionUtils.isNotEmpty(ids)) {
            builder.in("id", ids);
        }
        return queryList(builder);
    }

    @Override
    public int checkExist(Long orgId, Integer type, String name) {
        Preconditions.checkArgument(StringUtils.isNoneBlank(name), "分类名不能为空");
        SingleSqlBuilder<WxCategory> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("name", name);
        builder.eq("isDel", DeleteStatus.NORMAL.getValue());
        builder.count("id");
        Integer count = queryForObject(builder, Integer.class);
        return count != null ? count : 0;
    }
}
