package com.baijia.tianxiao.dal.org.dao.impl;

import java.sql.Time;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.dao.OrgTimeSpanDao;
import com.baijia.tianxiao.dal.org.po.OrgTimeSpan;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * 机构课程时间段操作
 * 
 * @title OrgTimeSpanDaoImpl
 * @desc TODO
 * @author shizuwei
 * @date 2015年12月26日
 * @version 1.0
 */
@Repository
public class OrgTimeSpanDaoImpl extends JdbcTemplateDaoSupport<OrgTimeSpan> implements OrgTimeSpanDao {

    public OrgTimeSpanDaoImpl() {
        super(OrgTimeSpan.class);
    }

    @Override
    public void addOrgTimeSpan(Long orgId, Time startTime, Time endTime) {
        OrgTimeSpan obj = new OrgTimeSpan();
        obj.setOrgId(orgId);
        obj.setStartTime(startTime);
        obj.setEndTime(endTime);
        this.save(obj);
    }

    @Override
    public List<OrgTimeSpan> listOrgTimeSpan(Long orgId)
    {
        SingleSqlBuilder<OrgTimeSpan> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.desc("startTime");
        return queryList(builder);
    }

}
