
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.constant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @title SignStatus
 * @desc 签到状态
 * @author shanyu
 * @date 2015年12月30日
 * @version 1.0
 */

public enum SignStatus {

    UNSIGN(0, "未签到"),

    SIGNED(1, "到课"),

    LEAVE(2, "请假"),

    ABSENT(3, "缺课"),;
    private int code;

    private String message;

    public final static Set<Integer> OPERATED_STATUS = new HashSet<>();// 用户已操作的状态

    static {
        OPERATED_STATUS.add(SIGNED.code);
        OPERATED_STATUS.add(LEAVE.code);
        OPERATED_STATUS.add(ABSENT.code);
    }

    private static Map<Integer, SignStatus> map;

    private SignStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    static {
        map = new HashMap<>();
        for (SignStatus status : SignStatus.values()) {
            map.put(status.code, status);
        }
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static SignStatus getSignStatusByCode(Integer code) {
        return map.get(code);
    }

    /**
     * @param signStatus
     * @return
     */
    public static String createSignStr(int signStatus) {
        String signStatusStr = "未知";
        if (signStatus == SignStatus.UNSIGN.code) {
            signStatusStr = "未签到";
        } else if (signStatus == SignStatus.SIGNED.code) {
            signStatusStr = "已签到";
        } else if (signStatus == SignStatus.LEAVE.code) {
            signStatusStr = "已请假";
        } else if (signStatus == SignStatus.ABSENT.code) {
            signStatusStr = "未到课";
        }
        return signStatusStr;
    }
}
