package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * 网校新闻
 * Created by wangsixia on 2017/1/13.
 */
@Data
@Entity
@Table(name = "wx_news", catalog = "tts")
public class WxNews {

    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "org_id")
    private Long orgId;

    // 新闻分类id
    @Column(name = "category_id")
    private Long categoryId;

    // 新闻发布状态 PublishStatus
    @Column(name = "status")
    private Integer status;

    // 新闻标题
    @Column(name = "title")
    private String title;

    // 新闻封面id, OrgStorage.id
    @Column(name = "cover_id")
    private Long coverId;

    // 新闻详情富文本
    @Column(name = "rich_content")
    private String richContent;

    // 新闻详情剔除标签的纯文本,用于搜索
    @Column(name = "text_content")
    private String textContent;

    // 新闻添加人
    @Column(name = "operator_id")
    private Integer operatorId;

    @Column(name = "is_del")
    private Integer isDel;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;
    // 新闻发布时间
    @Column(name = "publish_time", defaultVal = "0")
    private Date publishTime;
}
