
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxFavoriteDao;
import com.baijia.tianxiao.dal.org.po.WxFavorite;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Lists;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @title OrgFavoriteDaoImpl
 * @desc TODO
 * @author leiruiqi
 * @date 2016年12月28日
 * @version 1.0
 */

@Repository
public class WxFavoriteDaoImpl extends JdbcTemplateDaoSupport<WxFavorite> implements WxFavoriteDao {

    public List<WxFavorite> listByTypesAndBizId(@NonNull Long orgId, List<Integer> types, @NonNull Long bizId){
        if(CollectionUtils.isEmpty(types)){
            return Lists.newArrayList();
        }
        SingleSqlBuilder<WxFavorite> builder = this.createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.in("type", types);
        builder.eq("bizId", bizId);
        return this.queryList(builder);
    }
    
}
