
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import java.util.Collection;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.dao.OrgTeacherBranchDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacherBranch;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;

/**
 * @title OrgTeacherBranchDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月25日
 * @version 1.0
 */
@Repository
public class OrgTeacherBranchDaoImpl extends JdbcTemplateDaoSupport<OrgTeacherBranch> implements OrgTeacherBranchDao {

    public OrgTeacherBranchDaoImpl() {
        super(OrgTeacherBranch.class);
    }

    @Override
    public List<OrgTeacherBranch> getBranchTeacher(Long orgId, Long branchId, Integer jobType, Collection<Long> userIds,
        String...queryProps) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        SingleSqlBuilder<OrgTeacherBranch> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        if (branchId != null) {
            builder.eq("branchId", branchId);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (jobType != null) {
            builder.eq("type", jobType);
        }
        return queryList(builder);
    }

}
