package com.baijia.tianxiao.constant;

import lombok.Getter;

/**
 * @author weihongyan
 * @description TODO
 * @date 04/01/2017
 */
public enum OrgLessonSignSourceEnum {
    UNKNOWN(-1, "未知来源"),
    NORMAL(1, "正常签到"),
    BATCH(2, "批量签到"),
    FAST(3, "快速签到"),
    ;

    @Getter
    private int value;
    @Getter
    private String str;

    OrgLessonSignSourceEnum(int value, String str) {
        this.value = value;
        this.str = str;
    }

    public static String getStrByValue(int value) {
        for (OrgLessonSignSourceEnum enu : OrgLessonSignSourceEnum.values()) {
            if (enu.getValue() == value) {
                return enu.getStr();
            }
        }
        return null;
    }
}
