
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.constant;

import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.base.Preconditions;

import java.util.Calendar;
import java.util.Date;

/**
 * @title CommentStatus
 * @desc TODO
 * @author bjhl
 * @date 2016年1月4日
 * @version 1.0
 */

public enum CommentStatus {
    NOT_BEGIN(0, "未开始"),

    WAIT_COMMENT(1, "待评价"),

    COMMENTED(2, "已评价"),

   // TIMEOUT(3, "未评价"),

    ;
    private int code;

    private String message;

    private CommentStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static CommentStatus getCommentStatusByTime(Date startTime, Date endTime, boolean isStudent) {
        Preconditions.checkArgument(startTime != null, "startTime is illegal");
        Preconditions.checkArgument(endTime != null, "endTime is illegal");
//        Preconditions.checkArgument(startTime.before(endTime), "startTime is after endTime");

        Calendar now = Calendar.getInstance();
        //Date timeOutDate = DateUtil.getDiffDateTime(endTime, 7);
        if (endTime.after(now.getTime())) {
            return CommentStatus.NOT_BEGIN;
        } /*else if (timeOutDate.before(now.getTime())) {
            return CommentStatus.TIMEOUT;
        } */else {
            return WAIT_COMMENT;
        }
    }
}
