/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.po;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @title Message
 * @desc TODO 
 * @author he11o
 * @date 2016年11月23日
 * @version 1.0
 */

@Entity(name = "tx_vzhibo_message", dataSourceBeanName = "ttsDataSource")
@Table(catalog = "tts")
@Data
public class TxVZhiBoMessage {
 
    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "unique_id")
    private String uniqueId;
    
    @Column(name = "lesson_id")
    private Integer lessonId;    //直播间id
    
    @Column(name = "openid")
    private String openid;  //TODO 微信
    
    @Column(name = "student_id")
    private Long studentId; //天校学员id
    
    @Column(name = "msg_type")
    private Integer msgType;    //消息类型 ，文本、图片 or 语音
    
    @Column(name = "area_type")
    private Integer areaType;   //消息区域，直播区 or 讨论区
    
    @Column(name = "content")
    private String content; //消息内容，文本 or url
    
    @Column(name = "storage_id")
    private Long storageId;
    
    @Column(name = "url")
    private String url;     //消息附件的url
    
    @Column(name = "height")
    private Integer height;
    
    @Column(name = "width")
    private Integer width;
    
    @Column(name = "duration")
    private Integer duration;
    
    @Column(name = "create_time")
    private Date createTime;
    
    @Column(name = "avatar")
    private String avatar;          //消息发送者的头像
    
    @Column(name = "nickname")
    private String nickname;      //消息发送者的昵称
}
