
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxCloudSourceDao;
import com.baijia.tianxiao.dal.org.dto.WxCloudSourceDto;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @title OrgClouldSourceDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月26日
 * @version 1.0
 */

@Repository
public class WxCloudSourceDaoImpl extends JdbcTemplateDaoSupport<WxCloudSource> implements WxCloudSourceDao {

    public List<WxCloudSource> listByDtoConditon(WxCloudSourceDto dto, PageDto pageDto){
        SingleSqlBuilder<WxCloudSource> sqlBuilder = this.createSqlBuilder();
        
        if(dto.getOrgId()!=null){
            sqlBuilder.eq("orgId",dto.getOrgId());
        }
        if(dto.getBizType()!=null){
            sqlBuilder.eq("bizType",dto.getBizType());
        }
        if(dto.getVisible()!=null){
            sqlBuilder.eq("visible",dto.getVisible());
        }
        if(dto.getStartDate()!=null){
            sqlBuilder.ge("createTime", dto.getStartDate());
        }
        if(dto.getEndDate()!=null){
            sqlBuilder.le("createTime", dto.getEndDate());
        }
        if(dto.getStatus()!=null){
            sqlBuilder.eq("status", dto.getStatus());
        }
        if(dto.getIsForbidden()!=null){
            sqlBuilder.eq("isForbidden", dto.getIsForbidden());
        }
        if(dto.getDelStatus()!=null){
            sqlBuilder.eq("delStatus", dto.getDelStatus());
        }
        List<Expression> orExpressionList = new ArrayList<Expression>();
        if(StringUtils.isNotBlank(dto.getTag())){
            orExpressionList.add(Expressions.like("tags", "#"+dto.getTag()+"#",MatchMode.ANYWHERE));
        }
        if(StringUtils.isNotBlank(dto.getNameKey())){
            orExpressionList.add(Expressions.like("name", dto.getNameKey(),MatchMode.ANYWHERE));
        }
        if(CollectionUtils.isNotEmpty(orExpressionList)){
            sqlBuilder.and(Expressions.or(orExpressionList.toArray(new Expression[]{})));
        }

        sqlBuilder.desc("id");
//        sqlBuilder.setOrder(Order.asc("id"));
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    @Override
    public Long sumByCondition(Map<String, Object> condition) {
        
        SingleSqlBuilder<WxCloudSource> sqlBuilder = this.createSqlBuilder();
        
        sqlBuilder.sum("size","valuesum");
        
        this.fillBuilderByCondition(condition, sqlBuilder, null);
        
        return queryForObject(sqlBuilder, Long.class);
            
    }
    
    @Override
    public WxCloudSource getByCondition(Map<String, Serializable> condition) {
        
        SingleSqlBuilder<WxCloudSource> sqlBuilder = this.createSqlBuilder();
        
        for(Map.Entry<String, Serializable> entry:condition.entrySet()){
            sqlBuilder.eq(entry.getKey(), entry.getValue());
        }
        
        return this.uniqueResult(sqlBuilder);
            
    }
}

    