
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxBizScheduleDao;
import com.baijia.tianxiao.dal.org.po.WxBizSchedule;
import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title WxBizScheduleDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月24日
 * @version 1.0
 */

@Repository
public class WxBizScheduleDaoImpl extends JdbcTemplateDaoSupport<WxBizSchedule> implements WxBizScheduleDao{

    @Override
    public int updateForChangeStatusByBizTypeAndKey(Integer bizType, Long bizKey,Integer status,Integer newStatus) {
        
        Map<String,Object> condition = Maps.newHashMap();
        String sql = "update tts.wx_biz_schedule set status=:newStatus where bizType=:bizType and bizkey=:bizKey and status=:status";
        return getNamedJdbcTemplate().update(sql, condition);
            
    }

    @Override
    public List<WxBizSchedule> queryByScheduleTimeAndStatus(Date scheduleTime, Integer status) {
        
        SingleSqlBuilder<WxBizSchedule> builder = createSqlBuilder();
        builder.le("scheduleTime", scheduleTime);
        builder.eq("status", status);
        
        return this.queryList(builder);
            
    }

    
    
}

    