package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;

/**
 * 网校分类
 * Created by wangsixia on 2017/1/13.
 */
public interface WxCategoryDao extends CommonDao<WxCategory> {

    /**
     * 获取分类列表
     * @param orgId
     * @param type 分类类型 CategoryType
     * @param ids 分类ids
     * @return
     */
    List<WxCategory> getListByParam(Long orgId, Integer type, Collection<Long> ids);

    /**
     * 校验机构某一分类下的分类名是否已存在
     * @param orgId
     * @param type 分类类型 CategoryType
     * @param name 分类名
     * @return
     */
    int checkExist(Long orgId, Integer type, String name);
}
