package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface OrgStudentCourseDao extends CommonDao<OrgStudentCourse> {
    /**
     * 获取课程学生id
     *
     * @param orgId
     * @param courseId
     * @return
     */
    public List<Long> getStudents(Long orgId, Long courseId);

    public List<Long> getStudents(Long orgId, Long courseId, Integer status);

    /**
     * 获取学生列表
     *
     * @return
     */
    public List<OrgStudentCourse> getStudentListByStudentId(Long userId, String... queryProps);

    /**
     * 根据课程id集合获取关联学生信息
     *
     * @param queryProps
     * @return
     */
    public Map<Long, List<OrgStudentCourse>> getStudentMapBycourseIds(Collection<Long> courseIds, String... queryProps);

    public Map<Long, List<OrgStudentCourse>> getStudentMapBycourseIds(Collection<Long> courseIds, int status, String... queryProps);

    public Map<Long, List<OrgStudentCourse>> getStudentMapToRealCourseIds(Collection<Long> courseIds, int status, String... queryProps);


    /**
     * 根据课程id集合获取关联学生信息
     *
     * @return
     */
    public Map<Long, List<Long>> getStudentIdMapBycourseIds(Collection<Long> courseIds, Long orgId);

    public Map<Long, List<Long>> getCourseIdMapByStuIds(Collection<Long> stuId, Long orgId);

    /**
     * 返回每个courseId对应的当前的Student数目
     *
     * @param courseIds
     * @param queryProps
     * @return courseId和学生数目的Map
     */

    public Map<Long, Integer> getCurStudentCntByCourseIds(Long orgId, Collection<Long> courseIds, String... queryProps);

    /**
     * 更新学生姓名
     *
     * @param studentName
     */
    public void updateStudentName(Long userId, String studentName);

    /**
     * @param orgId
     * @param courseId
     * @param queryProps
     * @return
     */
    List<OrgStudentCourse> getStudentListByCourseId(Long orgId, Long courseId, String... queryProps);

    /**
     * 分页查询班级学生信息：不包含转班和退班的学生
     *
     * @param orgId
     * @param courseId
     * @param pageDto
     * @return
     */
    List<OrgStudentCourse> getStudentListByCourseId(Long orgId, Long courseId, PageDto pageDto);

    /**
     * 课程学生退班
     *
     * @param orgId
     * @param courseId
     * @return
     */
    void deleteOrgCourseStudent(Long orgId, Long courseId, Long userId, Integer status);

    /**
     * 批量处理课程学生退班
     *
     * @param orgId
     * @param courseId
     * @param userIds
     * @param status:  OrgCourseStudentOpStatus
     * @return
     */
    void batchDeleteOrgCourseStudent(Long orgId, Long courseId, Collection<Long> userIds, Integer status);

    /**
     * 获取课程学生数量
     *
     * @param orgId
     * @param courseIds
     * @return
     */
    Map<Long, Integer> getStudentCount(Long orgId, Collection<Long> courseIds);

    OrgStudentCourse getStudentCourse(Long orgId, Long courseId, Long userId);

    /**
     *
     * @param orgId
     * @param realCourseId
     * @param userId
     * @return
     */
    OrgStudentCourse getStudentCourseByRealCourseId(Long orgId, Long realCourseId, Long userId);


    List<OrgStudentCourse> getOrgCourseIds(Long orgId, Long userId, PageDto pageDto);

    List<OrgStudentCourse> getOrgCourseByOrgId(Long orgId, Collection<Long> courseIds, PageDto pageDto);

    List<OrgStudentCourse> getOrgCourseIds(Long orgId, Long userId, Integer status, PageDto pageDto);

    Integer getStudentCourseCount(Long orgId, Long userId, Integer status);

    Integer getStudentSignupCourseCount(Long orgId, Long userId, Integer status);

    List<Long> getStudentCourseIds(Long orgId, Long userId, Integer status);
    
    List<Long> getStudentIdsByCourseIds(Long orgId, Collection<Long> courseIds);

    List<Long> getOrgCourseIds(Long orgId, List<Long> courseIds, boolean ascByStuCnt, PageDto pageDto);

    Map<Long, Integer> getStudentCount(Long orgId, Collection<Long> courseIds, Boolean tradeComplete);

    public Map<Long, Integer> getStudentCountNoStatus(final Long orgId, Collection<Long> courseIds,
                                                      final Boolean tradeComplete);

    public List<Long> getStudentCourseIdsByStatus(Long orgId, Long userId, List<Integer> status);

    void refreshOrgStudentCourse(Long orgId, Long id);

    /**
     * 机构学员与报班courseIds之间映射
     */
    public List<OrgStudentCourse> getOrgStudentCourseByUserIds(Long orgId, Collection<Long> userIds, String... props);

    /**
     * 根据userIds获取已报班学生userId
     *
     * @param orgId
     * @param userIds
     * @return
     */
    List<Long> getEnrollClassUserIdByUserIds(Long orgId, Collection<Long> userIds);

    Map<Integer, Integer> allCourseOrgIdMap();

    public void deleteByOrgCourseId(Integer orgId, Integer courseId);

    /**
     * @param orgId
     * @param filterIds
     * @param noDelCourseIds
     * @param allCourse
     * @desc 根据指定班级的ID, 以及是否是查询全部来检索学员数据
     */
    public List<OrgStudentCourse> searchStudentWithCourseIds(Long orgId, Set<Long> filterIds, List<Long> noDelCourseIds, boolean allCourse);

    public Map<Long, List<Long>> getStudentIdMapBycourseIdsNoStatus(Collection<Long> courseIds, final Long orgId);

    /**
     * 分页查询天校下所有的报名记录
     */
    public List<OrgStudentCourse> getOrgStudentCourseByOrgIds(Collection<Long> orgIds, PageDto pageDto);

    /**
     * @param orgId
     * @return
     */
    public Map<Long, List<Long>> getOrgCourseIdMap(long orgId, Set<Long> userIds);

    public int sumOneToOneClassHours(Collection<Long> classIds);

    /**
     * @param orgId
     * @param courseIds
     * @return
     */

    List<OrgStudentCourse> getOrgCourseByOrgIdAndIds(Long orgId, Collection<Long> courseIds);

    /**
     * @param studentIds
     * @param orgId
     * @return
     */
    public List<StudentClassHourStatusDocument> searchStudentClassHourStatus(Set<Long> studentIds, Long orgId);

    /**
     * 查询一对一课程的总价
     *
     * @param orgId    ： 机构id
     * @param courseId ： 课程id
     * @return
     */
//	public Double getVipClassTotalPrice(Long orgId, Long courseId);

    public List<OrgStudentCourse> getPageByCourseIdAndMaxId(Long orgId,Long courseId,Integer limit,Long maxId);

    /**
     * 根据学生ID和班级id 应该可以找到唯一值
     */
    OrgStudentCourse getByStudentAndClassId(Long orgId, Long useId, Collection<Long> classIds);

    /**
     * 根据学生信息查找符合的课程id
     */
    List<OrgStudentCourse> getByCourseIdsStudentId(Long orgId, Collection<Long> courseIds, Long userId);
    
    List<OrgStudentCourse> getByCourseIdsStudentId(Long orgId, Collection<Long> courseIds, Collection<Long> userIds,
    Integer status, Integer delStatus);

    List<OrgStudentCourse> getStudentCourseByStuNameAndMobile(Long orgId, String studentName, String mobile,
        String... props);

    List<OrgStudentCourse> getBetweenId(Integer startId, Integer endId, List<Long> orgIds, Integer status, Integer delStatus, String...props);
    
    List<OrgStudentCourse> listByCourseId(Long orgId, Long courseId, Integer status, Integer delStatus);
    
    List<OrgStudentCourse> listByUserId(Long orgId, Long userId, Collection<Long> courseIds, Integer status);
    
    List<OrgStudentCourse> listByOrgId(Long orgId, Integer status);
    
    Integer countStudents(Long orgId, Long courseId, Integer status);
    
    List<Long> listReClassId(Long orgId, Long courseId, Integer status);
    
    List<Long> listStudentUserIdsByCourseIds(Long orgId, Long courseId);

    OrgStudentCourse listByCourseIdAndUserId(Long orgId, Long courseId,Long userId);

    /**
     * @param
     * @param maxSize
     * @return
     */
    public List<OrgStudentCourse> listAllNeedSyncRecord(long lastRecordId, Integer maxSize, Long...limitOrgIds);

    Map<Long, Integer> userMapByStatus(Long orgId, Long classId, Collection<Long> userIds, Collection<Integer> status);

    List<OrgStudentCourse> listByStatus(Long orgId, Long classId, Collection<Long> userIds, Collection<Integer> status, String... prop);

    public List<Long> selectOneToOneClassId(Long orgId);

    List<OrgStudentCourse> getNoRealCourseIdData();

    
    public Map<Long,Integer> mapStudentCount(Collection<Long> classIds);
    
    public Map<Long,List<Long>> mapCourseIdStuList(Collection<Long> classIds);
    


    /**
     * @param firstId
     * @param lastId
     * @return
     */
    List<OrgStudentCourse> listAllNeedSyncRecordWithRange(long firstId, long lastId);

    /**
     * @return
     */
    public int selectMaxId();

    /**
     * @param orgIds
     * @param courseIds
     * @param userIds
     * @return
     */
    public List<OrgStudentCourse> listByCourseIdsAndUserIds(Set<Long> orgIds, Set<Long> courseIds, Set<Long> userIds);
    
    public List<OrgStudentCourse> listOrderByName(Long courseId,Collection<Long> userIds,PageDto pageDto);

    /**
     * @param orgId
     * @param ownCourseIds
     */
    public Set<Long> listStudentUserIdsByCourseIds(Long orgId, List<Long> ownCourseIds);

}
