package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.LessonSignAudit;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * 签到
 *
 * @author shizuwei
 * @version 1.0
 * @title OrgLessonSignDao
 * @desc TODO
 * @date 2016年1月3日
 */
public interface OrgLessonSignDao extends CommonDao<OrgLessonSign> {

    /**
     * 签到信息列表
     */
    List<OrgLessonSign> getLessonSignList(Long orgId, Long courseId, Long lessonId, Long userId, Integer userRole,
                                          Integer status,boolean withUnsign, Date beginTime, Date endTime, String... props);

    List<OrgLessonSign> getUserLessonSignList(Long orgId, Collection<Long> userIds, Long courseId, Integer userRole,
                                              Integer status, String... props);

    /**
     * 课程签到数目
     */
    Map<Long, Integer> getOrgSignCount(Collection<Long> orgIds, Long userId, Integer userRole);

    Map<Long, Integer> getOrgCourseSignCount(Collection<Long> courseIds, Long userId, Integer userRole);

    Map<Long, Integer> getOrgLessonSignCount(Collection<Long> lessonIds, Integer userRole);

    /**
     * 修改签到状态
     */
    void orgLessonSignBatchEdit(Long lessonId, Collection<Long> userIds, Integer status, Long cascadeId, Integer source);
    
    /**
     * 修改签到状态
     */
    void orgLessonSignBatchEdit(Collection<Long> lessonId, Collection<Long> userIds, Integer status, Long cascadeId, Integer source);

    /**
     * 单个学生的签到情况
     */

    OrgLessonSign getStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long userId, Integer userRole);

    /**
     * 返回学生签到情况
     *
     * @param orgId
     * @param courseId
     * @param userId
     * @return
     */
    List<OrgLessonSign> getStudentLessonSign(Long orgId, Long courseId, Long userId);

    /**
     * @param orgId
     * @param lessonIds
     * @return
     */
    Map<Long, Integer> querySignedLessonStudentCountMap(Long orgId, Collection<Long> lessonIds);
    Map<Long, Integer> querySignLessonStudentCountMap(Long orgId, Collection<Long> lessonIds);

    /**
     * 获取学员签到情况
     *
     * @param orgId
     * @param lessonIds
     * @return
     */
    List<OrgLessonSign> getStudentLessonSign(final Long orgId, Long courseId, Collection<Long> lessonIds,
                                             final String... queryProps);

    /**
     * 获取课节学员签到情况
     *
     * @param orgId
     * @param lessonId
     * @return
     */
    List<OrgLessonSign> getStudentLessonSign(final Long orgId, Long lessonId, final String... queryProps);


    /**
     * @根据课节返回某个状态的数据
     * param orgId
     *
     * @param lessonId
     * @param status
     * @param queryProps
     * @return
     */
    List<OrgLessonSign> getStudentLessonByStatus(final Long orgId, Long lessonId, int status, final String... queryProps);

    /**
     * 查询用户的签到信息
     *
     * @param orgId
     * @param userId
     * @param userRole
     * @param lessonIds
     * @param queryProps
     * @return
     */
    List<OrgLessonSign> getStudentSign(Long orgId, Long userId, Integer userRole, Collection<Long> lessonIds,
                                       String... queryProps);

    /**
     * @param orgId
     * @param lessonId
     * @param userIds
     * @param sign
     * @return
     */
    List<OrgLessonSign> getLessonStudentIds(Long orgId, Long lessonId, Collection<Long> userIds, Integer sign,
                                            String... queryProps);

    boolean isStudentSignInLesson(Long orgId, Long lessonId, Long userId);

    /**
     * 获取各个课程的实际数量
     *
     * @param orgId
     * @param courseIds
     * @return
     */
    Map<Long, Integer> getCourseSignCountMap(Long orgId, Collection<Long> courseIds);
    // /**
    // * 学员签到情况
    // *
    // * @param lessonIds 课节id
    // * @param orgId 机构id
    // * @param signStatus 签到状态
    // * @param queryProps
    // * @return
    // */
    // Map<Long, List<OrgLessonSign>> getStudentLessonSignMap(Collection<Long> lessonIds, Long orgId,
    // Collection<Integer> signStatus, final String...queryProps);

    Map<Long, Integer> getOrgCourseStudentSignCount(Long orgId,Collection<Long> userIds, Long courseId);
    
    /**
     * 获取课程学员签到状态
     * @param userIds
     * @param courseId
     * @return
     */
    Map<Long, List<Integer>> getOrgCourseStudentSignMap(Collection<Long> userIds, final Long courseId);

    /**
     * 学生签到次数情况
     *
     * @param orgId
     * @param userIds
     * @return
     */
    Map<Long, Integer> getStudentSignCountMap(Long orgId, Collection<Long> userIds);

    /**
     * 获取课节签到统计结果
     *
     * @param orgId
     * @param lessonIds
     * @return
     */
    Map<Long, LessonSignAudit> queryLessonSignAudit(Long orgId, Collection<Long> lessonIds);

    // /**
    // * 获取课节学员签到数量
    // *
    // * @param lessonIds 课节
    // * @param orgId 机构
    // * @return
    // */
    // Map<Long, Integer> getLessonSignCountMap(Collection<Long> lessonIds, Long orgId);

    /**
     * 获取签到课节总数
     * @param orgId
     * @return
     */
    Map<Long, Integer> getOrgSignLessonTotal( Date startTime, Date endTime, List<Long> TianxiaoOrgIds) ;

    /**
     * 获取机构学生签到总数
     * @param orgId
     * @return
     */
    Map<Long, Integer> getOrgSignStudentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);
    
    public List<OrgLessonSign> getOrgClassLesson(List<Long> TianxiaoOrgIds);
    
    /**
     * 按照时间阶段给出签到信息
     */
    
    Map<String, Integer> getOrgSignMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds, Integer userRole);
    
    /**
     * 按日期给出课节签到
     */
    Map<String, List<Long>> getOrgSignLessonIdsMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);
    
    
    public List<OrgLessonSign> getCourseLessonSignIn(List<Long> courseIds);

    /**
     * 查询一对一已上课节次数
     * @param orgId
     * @param courseId
     * @param ruleValue
     * @return
     */
	int getVipLessonSignCount(Long orgId, Long courseId, int ruleValue);

    List<OrgLessonSign> getByCourseIdsAndUserIdsAndStatus(Long orgId, Collection<Long> courseIds, Collection<Long> userIds, Integer status, String...props);
    /**
     * 获取签到lessonId与studentId对应关系
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @param props
     * @return
     */
    List<OrgLessonSign> getByOrgIdCourseIdLessonIdsStudentIds(Long orgId, Long courseId, List<Long> lessonIds, List<Long> userIds, String...props);

    public List<OrgLessonSign> getByStudentLessonIds(Collection<Long> stuLessonIds,String... props);
    
    Map<Long,Integer> mapKeyLessonIdValueStatus(Long orgId, Long userId);
    

    Map<Integer, Integer> mapKeyStatusValueCount(Collection<Long> lessonIds, Long userId);
    
    Map<Long,Integer> mapKeyLessonIdValueCount(Collection<Long> lessonIds);
    
    //Map<courseId,Map<userId,Map<signinStatus, count>>>
    Map<Long,Map<Long,Map<Integer, Integer>>> mapStudentSignStatus(Collection<Long> lessonIds);

    List<OrgLessonSign> listByPage(Date startTime, Date endTime, PageDto pageDto);

    List<OrgLessonSign> listByUserClass(Long orgId,Long userId,Long courseId,Date time);
    

}
