package com.baijia.tianxiao.constant;

import lombok.Getter;
import java.util.HashMap;
import java.util.Map;

/**
 * 发布状态
 * Created by wangsixia on 2017/1/13.
 */
public enum PublishStatus {

    UN_PUBLISH(0, "未发布"),

    PUBLISH(1, "已发布")

    ;

    @Getter
    private int code;

    @Getter
    private String msg;

    private PublishStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, PublishStatus> map = new HashMap<>();

    static {
        for (PublishStatus item : values()) {
            map.put(item.getCode(), item);
        }
    }

    public static String getByCode(Integer code) {
        if (code != null && map.containsKey(code)) {
            return map.get(code).getMsg();
        } else {
            return "";
        }
    }
}
