/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.vzhibo.dao.impl;

import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class TxVZhiBoLessonDaoImpl
extends JdbcTemplateDaoSupport<TxVZhiBoLesson>
implements TxVZhiBoLessonDao {
    public static final String SYNC_LESSON_STATUS = "update tts.tx_vzhibo_lesson set status=:status where status <>:status  and start_time<:startTime";

    public TxVZhiBoLessonDaoImpl() {
        super(TxVZhiBoLesson.class);
    }

    @Override
    public int countOthersLesson(Integer roomId, Integer ownerId, Order order, PageDto dto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("roomId", (Serializable)roomId);
        builder.ne("ownerId", (Serializable)ownerId);
        builder.addOrder(order);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxVZhiBoLesson> queryOthersByCondition(Integer roomId, Integer ownerId, Order order, PageDto dto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        builder.ne("ownerId", (Serializable)ownerId);
        builder.addOrder(order);
        return this.queryList(builder);
    }

    @Override
    public TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)Integer.valueOf(id));
        return (TxVZhiBoLesson)this.uniqueResult(builder);
    }

    @Override
    public int syncLessonStatus(Date timeBefore, int status) {
        HashMap params = Maps.newHashMap();
        params.put("status", status);
        params.put("startTime", timeBefore);
        return this.getNamedJdbcTemplate().update(SYNC_LESSON_STATUS, (Map)params);
    }

    @Override
    public List<TxVZhiBoLesson> list(Integer roomId, Integer ownerId, Long lastId, Integer pageSize, Order order, int status) {
        TxVZhiBoLesson boLesson;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        if (ownerId != null) {
            builder.eq("ownerId", (Serializable)ownerId);
        }
        if (status != -1) {
            builder.eq("status", (Serializable)Integer.valueOf(status));
        } else {
            builder.ne("status", (Serializable)Integer.valueOf(TxVZhiBoLessonStatusEnums.DELETED.getCode()));
        }
        if (lastId != null && (boLesson = (TxVZhiBoLesson)this.getById(lastId, new String[0])) != null) {
            builder.lt("startTime", (Serializable)boLesson.getStartTime());
        }
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        builder.addOrder(order);
        return this.queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> listOthers(Integer roomId, Integer ownerId, Long lastId, Integer pageSize, Order order, int status) {
        TxVZhiBoLesson boLesson;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        if (ownerId != null) {
            builder.ne("ownerId", (Serializable)ownerId);
        }
        if (status != -1) {
            builder.eq("status", (Serializable)Integer.valueOf(status));
        } else {
            builder.ne("status", (Serializable)Integer.valueOf(TxVZhiBoLessonStatusEnums.DELETED.getCode()));
        }
        if (lastId != null && (boLesson = (TxVZhiBoLesson)this.getById(lastId, new String[0])) != null) {
            builder.lt("startTime", (Serializable)boLesson.getStartTime());
        }
        if (pageSize != null) {
            builder.setMaxSize(pageSize);
        }
        builder.addOrder(order);
        return this.queryList(builder);
    }

    @Override
    public List<TxVZhiBoLesson> getByRoomId(Integer roomId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("roomId", (Serializable)roomId);
        builder.select(new String[]{"id", "roomId", "status"});
        return this.queryList(builder);
    }
}

