/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.vzhibo.dao;

import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title TxVZhiBoLessonDao
 * @desc TODO 
 * @author caoliang
 * @date 2016年11月28日
 * @version 1.0
 */
public interface TxVZhiBoLessonDao extends CommonDao<TxVZhiBoLesson>{

    /**
     * 查询直播间其他老师的直播课数量 
     * @param roomId    当前直播间id
     * @param ownerId   当前账号id
     * @param desc      排序
     * @param dto       分页
     * @return
     */
    int countOthersLesson(Integer roomId, Integer ownerId, Order desc, PageDto dto);

    /**
     * 查询直播间其他老师的直播课详情
     * @param roomId    当前直播间id
     * @param ownerId   当前账号id
     * @param desc      排序
     * @param dto       分页
     * @return
     */
    List<TxVZhiBoLesson> queryOthersByCondition(Integer roomId, Integer ownerId, Order desc, PageDto dto);

    TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int lessonId);

    /**
     * 将$time 之前的状态不为$status的直播间设置为$status
     * @param timeBefore
     * @return
     */
    int syncLessonStatus(Date timeBefore, int status);

    List<TxVZhiBoLesson> list(Integer roomId, Integer ownerId, Long lastId, Integer pageSize, Order desc, int status);

    List<TxVZhiBoLesson> listOthers(Integer roomId, Integer ownerId, Long lastId, Integer pageSize, Order desc,
                                    int status);
    
    List<TxVZhiBoLesson> getByRoomId(Integer roomId);
}
