
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import lombok.Data;

import java.util.Date;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgStudentCourse
 * @desc 机构课程学生关联表
 * @date 2015年10月12日
 */

@Entity(dataSourceBeanName = "ttsDataSource")
@Table(name = "org_student_course", catalog = "tts")
@Data
public class OrgStudentCourse extends BaseDto {
    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long orgId;

    @Column(name = "real_course_id")
    private Long realCourseId;

    @Column
    private Long courseId;

    //对应org_students表中user_id字段
    @Column(name = "student_id")
    private Long userId;

    @Column
    private String studentName;

    @Column
    private String studentMobile;

    @Column
    private Date createTime;

    @Column
    private Integer delStatus;

    @Column
    private int tradeComplete;

    /**
     * 0:正常，1：已经退班，2已经转班
     */
    @Column
    private Integer status;

    @Column
    private Integer lessonCount;

    @Column
    private Integer chargeUnit;

    @Column
    private Long signupPurchaseId;

    private int syncLessonCount;//同步标识（yunying.org_signup_course）

}
