package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.constant.PublishStatus;
import com.baijia.tianxiao.dal.org.dao.WxNewsDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.WxNews;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Created by wangsixia on 2017/1/13.
 */
@Repository
public class WxNewsDaoImpl extends JdbcTemplateDaoSupport<WxNews> implements WxNewsDao {

    @Override
    public List<WxNews> getListByParam (Long orgId, Collection<Long> ids, Long categoryId, String key, Integer status, Date start, Date end, Boolean descByPublish, PageDto pageDto, String...queryProps) {
        SingleSqlBuilder<WxNews> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("isDel", DeleteStatus.NORMAL.getValue());
        if (CollectionUtils.isNotEmpty(ids)) {
            builder.in("id", ids);
        }
        if (categoryId != null && categoryId > 0) {
            builder.eq("categoryId", categoryId);
        }
        if (StringUtils.isNotBlank(key)) {
            builder.like("title", key, MatchMode.ANYWHERE);
        }
        if (status != null) {
            builder.eq("status", status);
        }
        if (start != null) {
            builder.ge("createTime", start);
        }
        if (end != null) {
            builder.le("createTime", end);
        }
        if (descByPublish != null) {
            if (descByPublish) {
                builder.desc("publishTime");
            } else {
                builder.desc("createTime");
            }
        }
        builder.setPage(pageDto);
        return queryList(builder);
    }

    @Override
    public WxNews getById(Long orgId, Long id, Integer status, String...queryProps) {
        SingleSqlBuilder<WxNews> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("id", id);
        if (status != null) {
            builder.eq("status", status);
        }
        builder.eq("isDel", DeleteStatus.NORMAL.getValue());
        return uniqueResult(builder);
    }
}
