
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxConfigDao;
import com.baijia.tianxiao.dal.org.po.WxConfig;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @title OrgWxConfigDaoImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月28日
 * @version 1.0
 */

@Repository
public class WxConfigDaoImpl extends JdbcTemplateDaoSupport<WxConfig> implements WxConfigDao{

    @Transactional
    @Override
    public void save(Long orgId, Map<String, String> configMap) {
        
        Set<String> bizKeys =  configMap.keySet();
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", bizKeys);
        
        List<WxConfig> list = this.queryByCondition(condition, null);
        for(WxConfig config:list){
            String value = configMap.get(config.getBizKey());
            config.setValue(value);
            this.update(config, "value");
            configMap.remove(config.getBizKey());
        }
        
        for(Map.Entry<String, String> entry:configMap.entrySet()){
            
            WxConfig config = new WxConfig();
            config.setOrgId(orgId);
            config.setBizKey(entry.getKey());
            config.setValue(entry.getValue());
            this.save(config);
        }
    }

    
    
    
}

    