
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author cxm
 * @version 1.0
 * @title OrgTeacherLessonDao
 * @desc TODO
 * @date 2015年12月29日
 */
public interface OrgTeacherLessonDao extends CommonDao<OrgTeacherLesson> {

    /**
     * @param orgId
     * @param teacherIds
     * @param queryProps
     * @return
     */
    List<OrgTeacherLesson> queryTeacherLessons(Long orgId, Collection<Long> teacherIds, String... queryProps);
    
    List<OrgTeacherLesson> queryTeacherLessonsByLessonIds(String query, Long orgId, Collection<Long> lessonIds, String... queryProps);

    /**
     * @param orgId
     * @param teacherId
     * @return
     */
    List<Long> queryTeacherLessons(Long orgId, Long teacherId);

    /**
     * @param orgId
     * @param lessonId
     * @return
     */
    OrgTeacherLesson getByLessonId(Long orgId, Long lessonId);

    /**
     * 查找机构下面课节的老师ID和课节ID的映射
     *
     * @param orgId
     * @param lessonIds
     * @return
     */
    Map<Long, Long> queryLessonTeacherIdMap(Long orgId, Collection<Long> lessonIds);

    /**
     * @param lessonId
     * @param orgId
     * @return
     */
    List<Long> getUserIds(Long lessonId, Long orgId);

    /**
     * 老师是否在课节中
     *
     * @param lessonId
     * @param userId
     * @return
     */
    boolean isTeacherInLesson(Long lessonId, Long userId);

    /**
     * 根据结束时间筛选老师课节信息
     *
     * @param startTime
     * @param endTime
     * @return Map<Long, List<Long>> 课节Id->老师userId
     */
    Map<Long, List<Long>> getTeacherLessonByEndTime(Date startTime, Date endTime);

    /**
     * 根据开始时间筛选老师课节信息
     *
     * @param startTime
     * @param endTime
     * @return Map<Long, List<Long>> 课节Id->老师userId
     */
    Map<Long, List<Long>> getTeacherLessonByStartTime(Date startTime, Date endTime);

    int countTeacherLessonByMonth(Long teacherId, Date startTime, Date endTime);


    public Map<Long, OrgTeacherLesson> getOrgTeacherLessonMapByLessonIds(Collection<Long> lessonIds);

    /**
     * 根据课节id查询课节老师关联信息
     * @param orgId：机构id
     * @param classLessonIds：课节id集合
     * @return
     */
	List<OrgTeacherLesson> queryByLessonIds(Long orgId, Collection<Long> classLessonIds);
	
	Map<Long, List<Long>> getTeacherLessonByStartTime(Date startTime, Date endTime, Collection<Long> teacherUserIds);
	
	List<Long> getTeacherLessonIdsByStartTime(Date startTime, Date endTime, Long teacherUserId);
	
	//Map<teacherUserId, Map<courseId, List<lessonId>>>
	Map<Long, Map<Long, List<Long>>> getTeacherCourseLessonBy(Date startTime, Date endTime, Collection<Long> teacherUserIds);
	
	Integer countClassId(Date startTime, Date endTime, Long teacherUserId);
	List<Long> listClassId(Date startTime, Date endTime, Long teacherUserId, PageDto pageDto);
	
	List<Long> listLessonId(Collection<Long> lessonIds,Long teacherUserId);

}
